/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.classification;

import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import smile.classification.RDA;
import smile.demo.classification.ClassificationDemo;

public class RDADemo
extends ClassificationDemo {
    private double alpha = 0.5;
    private JTextField alphaField = new JTextField(Double.toString(this.alpha), 5);

    public RDADemo() {
        this.optionPane.add(new JLabel("\u03b1:"));
        this.optionPane.add(this.alphaField);
    }

    @Override
    public double[][] learn(double[] x, double[] y) {
        try {
            this.alpha = Double.parseDouble(this.alphaField.getText().trim());
            if (this.alpha < 0.0 || this.alpha > 1.0) {
                JOptionPane.showMessageDialog(this, "Invalid \u03b1: " + this.alpha, "Error", 0);
                return null;
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Invalid \u03b1: " + this.alphaField.getText(), "Error", 0);
            return null;
        }
        double[][] data = (double[][])dataset[datasetIndex].toArray((E[])new double[dataset[datasetIndex].size()][]);
        int[] label = dataset[datasetIndex].toArray(new int[dataset[datasetIndex].size()]);
        RDA qda = new RDA(data, label, this.alpha);
        for (int i = 0; i < label.length; ++i) {
            label[i] = qda.predict(data[i]);
        }
        double trainError = this.error(label, label);
        System.out.format("training error = %.2f%%\n", 100.0 * trainError);
        double[][] z = new double[y.length][x.length];
        for (int i = 0; i < y.length; ++i) {
            for (int j = 0; j < x.length; ++j) {
                double[] p = new double[]{x[j], y[i]};
                z[i][j] = qda.predict(p);
            }
        }
        return z;
    }

    @Override
    public String toString() {
        return "Regularized Disiminant Analysis";
    }

    public static void main(String[] argv) {
        RDADemo demo = new RDADemo();
        JFrame f = new JFrame("Regularized Disiminant Analysis");
        f.setSize(new Dimension(1000, 1000));
        f.setLocationRelativeTo(null);
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(demo);
        f.setVisible(true);
    }
}

