/*
 * Decompiled with CFR 0.152.
 */
package smile.association;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import smile.association.FPGrowth;
import smile.association.ItemSet;
import smile.association.TotalSupportTree;
import smile.data.parser.IOUtils;
import smile.math.Math;

public class TotalSupportTreeTest {
    int[][] itemsets = new int[][]{{1, 3}, {2}, {4}, {2, 3, 4}, {2, 3}, {2, 3}, {1, 2, 3, 4}, {1, 3}, {1, 2, 3}, {1, 2, 3}};

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testGetSupport() {
        System.out.println("getSupport");
        FPGrowth fpgrowth = new FPGrowth(this.itemsets, 3);
        TotalSupportTree ttree = fpgrowth.buildTotalSupportTree();
        int[][] items = new int[][]{{3, 2, 1}, {3}, {3, 1}, {3, 2}, {4}, {2}};
        Assert.assertEquals(3L, ttree.getSupport(items[0]));
        Assert.assertEquals(8L, ttree.getSupport(items[1]));
        Assert.assertEquals(5L, ttree.getSupport(items[2]));
        Assert.assertEquals(6L, ttree.getSupport(items[3]));
        Assert.assertEquals(3L, ttree.getSupport(items[4]));
        Assert.assertEquals(7L, ttree.getSupport(items[5]));
    }

    @Test
    public void testGetFrequentItemsets_0args() {
        System.out.println("getFrequentItemsets");
        FPGrowth fpgrowth = new FPGrowth(this.itemsets, 3);
        TotalSupportTree ttree = fpgrowth.buildTotalSupportTree();
        List<ItemSet> results = ttree.getFrequentItemsets();
        Assert.assertEquals(8L, results.size());
        Assert.assertEquals(8L, results.get((int)0).support);
        Assert.assertEquals(1L, results.get((int)0).items.length);
        Assert.assertEquals(3L, results.get((int)0).items[0]);
        Assert.assertEquals(7L, results.get((int)1).support);
        Assert.assertEquals(1L, results.get((int)1).items.length);
        Assert.assertEquals(2L, results.get((int)1).items[0]);
        Assert.assertEquals(3L, results.get((int)6).support);
        Assert.assertEquals(3L, results.get((int)6).items.length);
        Assert.assertEquals(3L, results.get((int)6).items[0]);
        Assert.assertEquals(2L, results.get((int)6).items[1]);
        Assert.assertEquals(1L, results.get((int)6).items[2]);
        Assert.assertEquals(3L, results.get((int)7).support);
        Assert.assertEquals(1L, results.get((int)7).items.length);
        Assert.assertEquals(4L, results.get((int)7).items[0]);
    }

    @Test
    public void testGetFrequentItemsets_PrintStream() {
        System.out.println("getFrequentItemsets");
        FPGrowth fpgrowth = new FPGrowth(this.itemsets, 3);
        TotalSupportTree ttree = fpgrowth.buildTotalSupportTree();
        long n = ttree.getFrequentItemsets(System.out);
        Assert.assertEquals(8L, n);
    }

    @Test
    public void testPima() {
        System.out.println("pima");
        ArrayList<int[]> dataList = new ArrayList<int[]>(1000);
        try {
            String line;
            BufferedReader input = IOUtils.getTestDataReader("transaction/pima.D38.N768.C2");
            int nrow = 0;
            while ((line = input.readLine()) != null) {
                if (!line.trim().isEmpty()) {
                    String[] s = line.split(" ");
                    int[] point = new int[s.length];
                    for (int i = 0; i < s.length; ++i) {
                        point[i] = Integer.parseInt(s[i]);
                    }
                    dataList.add(point);
                }
                ++nrow;
            }
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
        int[][] data = (int[][])dataList.toArray((T[])new int[dataList.size()][]);
        int n = Math.max(data);
        System.out.format("%d transactions, %d items%n", data.length, n);
        long time = System.currentTimeMillis();
        FPGrowth fpgrowth = new FPGrowth(data, 20);
        System.out.format("Done building FP-tree: %.2f secs.%n", (double)(System.currentTimeMillis() - time) / 1000.0);
        time = System.currentTimeMillis();
        TotalSupportTree ttree = fpgrowth.buildTotalSupportTree();
        System.out.format("Done building total support tree: %.2f secs.%n", (double)(System.currentTimeMillis() - time) / 1000.0);
        time = System.currentTimeMillis();
        long numItemsets = ttree.getFrequentItemsets(System.out);
        System.out.format("%d frequent item sets discovered: %.2f secs.%n", numItemsets, (double)(System.currentTimeMillis() - time) / 1000.0);
        Assert.assertEquals(1803L, numItemsets);
        Assert.assertEquals(1803L, ttree.getFrequentItemsets().size());
    }

    @Test
    public void testKosarak() {
        System.out.println("kosarak");
        ArrayList<int[]> dataList = new ArrayList<int[]>(1000);
        try {
            String line;
            BufferedReader input = IOUtils.getTestDataReader("transaction/kosarak.dat");
            int nrow = 0;
            while ((line = input.readLine()) != null) {
                if (!line.trim().isEmpty()) {
                    String[] s = line.split(" ");
                    HashSet<Integer> items = new HashSet<Integer>();
                    for (int i = 0; i < s.length; ++i) {
                        items.add(Integer.parseInt(s[i]));
                    }
                    int j = 0;
                    int[] point = new int[items.size()];
                    Iterator iterator = items.iterator();
                    while (iterator.hasNext()) {
                        int i = (Integer)iterator.next();
                        point[j++] = i;
                    }
                    dataList.add(point);
                }
                ++nrow;
            }
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
        int[][] data = (int[][])dataList.toArray((T[])new int[dataList.size()][]);
        int n = Math.max(data);
        System.out.format("%d transactions, %d items%n", data.length, n);
        long time = System.currentTimeMillis();
        FPGrowth fpgrowth = new FPGrowth(data, 1500);
        System.out.format("Done building FP-tree: %.2f secs.%n", (double)(System.currentTimeMillis() - time) / 1000.0);
        time = System.currentTimeMillis();
        TotalSupportTree ttree = fpgrowth.buildTotalSupportTree();
        System.out.format("Done building total support tree: %.2f secs.%n", (double)(System.currentTimeMillis() - time) / 1000.0);
        time = System.currentTimeMillis();
        Assert.assertEquals(219725L, ttree.getFrequentItemsets().size());
    }
}

