/*
 * Decompiled with CFR 0.152.
 */
package smile.association;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import smile.association.FPGrowth;
import smile.association.ItemSet;
import smile.data.parser.IOUtils;
import smile.math.Math;

public class FPGrowthTest {
    int[][] itemsets = new int[][]{{1, 3}, {2}, {4}, {2, 3, 4}, {2, 3}, {2, 3}, {1, 2, 3, 4}, {1, 3}, {1, 2, 3}, {1, 2, 3}};

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testLearn_0args() {
        System.out.println("learn");
        FPGrowth fpgrowth = new FPGrowth(this.itemsets, 3);
        List<ItemSet> results = fpgrowth.learn();
        Assert.assertEquals(8L, results.size());
    }

    @Test
    public void testLearn_PrintStream() {
        System.out.println("learn");
        FPGrowth fpgrowth = new FPGrowth(this.itemsets, 3);
        long n = fpgrowth.learn(System.out);
        Assert.assertEquals(8L, n);
    }

    @Test
    public void testPima() {
        System.out.println("pima");
        ArrayList<int[]> dataList = new ArrayList<int[]>(1000);
        try {
            String line;
            BufferedReader input = IOUtils.getTestDataReader("transaction/pima.D38.N768.C2");
            int nrow = 0;
            while ((line = input.readLine()) != null) {
                if (!line.trim().isEmpty()) {
                    String[] s = line.split(" ");
                    int[] point = new int[s.length];
                    for (int i = 0; i < s.length; ++i) {
                        point[i] = Integer.parseInt(s[i]);
                    }
                    dataList.add(point);
                }
                ++nrow;
            }
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
        int[][] data = (int[][])dataList.toArray((T[])new int[dataList.size()][]);
        int n = Math.max(data);
        System.out.format("%d transactions, %d items%n", data.length, n);
        long time = System.currentTimeMillis();
        FPGrowth fpgrowth = new FPGrowth(data, 20);
        System.out.format("Done building FP-tree: %.2f secs.%n", (double)(System.currentTimeMillis() - time) / 1000.0);
        time = System.currentTimeMillis();
        long numItemsets = fpgrowth.learn(System.out);
        System.out.format("%d frequent item sets discovered: %.2f secs.%n", numItemsets, (double)(System.currentTimeMillis() - time) / 1000.0);
        Assert.assertEquals(1803L, numItemsets);
        Assert.assertEquals(1803L, fpgrowth.learn().size());
    }

    @Test
    public void testKosarak() {
        System.out.println("kosarak");
        ArrayList<int[]> dataList = new ArrayList<int[]>(1000);
        try {
            String line;
            BufferedReader input = IOUtils.getTestDataReader("transaction/kosarak.dat");
            int nrow = 0;
            while ((line = input.readLine()) != null) {
                if (!line.trim().isEmpty()) {
                    String[] s = line.split(" ");
                    HashSet<Integer> items = new HashSet<Integer>();
                    for (int i = 0; i < s.length; ++i) {
                        items.add(Integer.parseInt(s[i]));
                    }
                    int j = 0;
                    int[] point = new int[items.size()];
                    Iterator iterator = items.iterator();
                    while (iterator.hasNext()) {
                        int i = (Integer)iterator.next();
                        point[j++] = i;
                    }
                    dataList.add(point);
                }
                ++nrow;
            }
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
        int[][] data = (int[][])dataList.toArray((T[])new int[dataList.size()][]);
        int n = Math.max(data);
        System.out.format("%d transactions, %d items%n", data.length, n);
        long time = System.currentTimeMillis();
        FPGrowth fpgrowth = new FPGrowth(data, 1500);
        System.out.format("Done building FP-tree: %.2f secs.%n", (double)(System.currentTimeMillis() - time) / 1000.0);
        time = System.currentTimeMillis();
        List<ItemSet> results = fpgrowth.learn();
        System.out.format("%d frequent item sets discovered: %.2f secs.%n", results.size(), (double)(System.currentTimeMillis() - time) / 1000.0);
        Assert.assertEquals(219725L, results.size());
    }
}

