/*
 * Decompiled with CFR 0.152.
 */
package smile.association;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import smile.association.ARM;
import smile.association.AssociationRule;
import smile.data.parser.IOUtils;
import smile.math.Math;

public class ARMTest {
    int[][] itemsets = new int[][]{{1, 3}, {2}, {4}, {2, 3, 4}, {2, 3}, {2, 3}, {1, 2, 3, 4}, {1, 3}, {1, 2, 3}, {1, 2, 3}};

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testLearn() {
        System.out.println("learn");
        ARM instance = new ARM(this.itemsets, 3);
        instance.learn(0.5, System.out);
        List<AssociationRule> rules = instance.learn(0.5);
        Assert.assertEquals(9L, rules.size());
        Assert.assertEquals(0.6, rules.get((int)0).support, 0.01);
        Assert.assertEquals(0.75, rules.get((int)0).confidence, 0.01);
        Assert.assertEquals(1L, rules.get((int)0).antecedent.length);
        Assert.assertEquals(3L, rules.get((int)0).antecedent[0]);
        Assert.assertEquals(1L, rules.get((int)0).consequent.length);
        Assert.assertEquals(2L, rules.get((int)0).consequent[0]);
        Assert.assertEquals(0.3, rules.get((int)4).support, 0.01);
        Assert.assertEquals(0.6, rules.get((int)4).confidence, 0.01);
        Assert.assertEquals(1L, rules.get((int)4).antecedent.length);
        Assert.assertEquals(1L, rules.get((int)4).antecedent[0]);
        Assert.assertEquals(1L, rules.get((int)4).consequent.length);
        Assert.assertEquals(2L, rules.get((int)4).consequent[0]);
        Assert.assertEquals(0.3, rules.get((int)8).support, 0.01);
        Assert.assertEquals(0.6, rules.get((int)8).confidence, 0.01);
        Assert.assertEquals(1L, rules.get((int)8).antecedent.length);
        Assert.assertEquals(1L, rules.get((int)8).antecedent[0]);
        Assert.assertEquals(2L, rules.get((int)8).consequent.length);
        Assert.assertEquals(3L, rules.get((int)8).consequent[0]);
        Assert.assertEquals(2L, rules.get((int)8).consequent[1]);
    }

    @Test
    public void testLearnPima() {
        System.out.println("pima");
        ArrayList<int[]> dataList = new ArrayList<int[]>(1000);
        try {
            String line;
            BufferedReader input = IOUtils.getTestDataReader("transaction/pima.D38.N768.C2");
            int nrow = 0;
            while ((line = input.readLine()) != null) {
                if (!line.trim().isEmpty()) {
                    String[] s = line.split(" ");
                    int[] point = new int[s.length];
                    for (int i = 0; i < s.length; ++i) {
                        point[i] = Integer.parseInt(s[i]);
                    }
                    dataList.add(point);
                }
                ++nrow;
            }
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
        int[][] data = (int[][])dataList.toArray((T[])new int[dataList.size()][]);
        int n = Math.max(data);
        System.out.format("%d transactions, %d items%n", data.length, n);
        ARM instance = new ARM(data, 20);
        long numRules = instance.learn(0.9, System.out);
        System.out.format("%d association rules discovered%n", numRules);
        Assert.assertEquals(6803L, numRules);
        Assert.assertEquals(6803L, instance.learn(0.9).size());
    }

    @Test
    public void testLearnKosarak() {
        System.out.println("kosarak");
        ArrayList<int[]> dataList = new ArrayList<int[]>(1000);
        try {
            String line;
            BufferedReader input = IOUtils.getTestDataReader("transaction/kosarak.dat");
            int nrow = 0;
            while ((line = input.readLine()) != null) {
                if (!line.trim().isEmpty()) {
                    String[] s = line.split(" ");
                    HashSet<Integer> items = new HashSet<Integer>();
                    for (int i = 0; i < s.length; ++i) {
                        items.add(Integer.parseInt(s[i]));
                    }
                    int j = 0;
                    int[] point = new int[items.size()];
                    Iterator iterator = items.iterator();
                    while (iterator.hasNext()) {
                        int i = (Integer)iterator.next();
                        point[j++] = i;
                    }
                    dataList.add(point);
                }
                ++nrow;
            }
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
        int[][] data = (int[][])dataList.toArray((T[])new int[dataList.size()][]);
        int n = Math.max(data);
        System.out.format("%d transactions, %d items%n", data.length, n);
        ARM instance = new ARM(data, 0.003);
        long numRules = instance.learn(0.5, System.out);
        System.out.format("%d association rules discovered%n", numRules);
        Assert.assertEquals(17932L, numRules);
    }
}

