/*
 * Decompiled with CFR 0.152.
 */
package com.mhuss.AstroLib;

public class MathOps {
    public static final int VECTOR_SIZE = 3;
    static final int MATRIX_SIZE = 9;

    public static double acose(double arg) {
        if (arg >= 1.0) {
            return 0.0;
        }
        if (arg <= -1.0) {
            return Math.PI;
        }
        return Math.acos(arg);
    }

    public static double asine(double arg) {
        if (arg >= 1.0) {
            return 1.5707963267948966;
        }
        if (arg <= -1.0) {
            return -1.5707963267948966;
        }
        return Math.asin(arg);
    }

    public static void setIdentityMatrix(double[] matrix) {
        for (int i = 0; i < 9; ++i) {
            matrix[i] = 0 != (i & 3) ? 0.0 : 1.0;
        }
    }

    public static void rotateVector(double[] v, double angle, int axis) {
        double sinAng = Math.sin(angle);
        double cosAng = Math.cos(angle);
        int a = (axis + 1) % 3;
        int b = (axis + 2) % 3;
        double temp = v[a] * cosAng - v[b] * sinAng;
        v[b] = v[b] * cosAng + v[a] * sinAng;
        v[a] = temp;
    }

    static void polar3ToCartesian(double[] vect, double lon, double lat) {
        double cosLat = Math.cos(lat);
        vect[0] = Math.cos(lon) * cosLat;
        vect[1] = Math.sin(lon) * cosLat;
        vect[2] = Math.sin(lat);
    }

    public static void polarToCartesian(double[] vect, double lon, double lat, double radius) {
        double cosLat = Math.cos(lat);
        vect[0] = Math.cos(lon) * cosLat * radius;
        vect[1] = Math.sin(lon) * cosLat * radius;
        vect[2] = Math.sin(lat) * radius;
    }

    public static void polarToCartesian(double[] vectC, double[] vectP) {
        MathOps.polarToCartesian(vectC, vectP[0], vectP[1], vectP[2]);
    }

    public static void cartesianToPolar(double[] cartVect, double[] polarCoord) {
        polarCoord[0] = Math.atan2(cartVect[1], cartVect[0]);
        polarCoord[1] = Math.atan2(cartVect[2], Math.sqrt(cartVect[0] * cartVect[0] + cartVect[1] * cartVect[1]));
        polarCoord[2] = Math.sqrt(cartVect[0] * cartVect[0] + cartVect[1] * cartVect[1] + cartVect[2] * cartVect[2]);
    }

    static void invertOrthonormalMatrix(double[] matrix) {
        double temp = matrix[1];
        matrix[1] = matrix[3];
        matrix[3] = temp;
        temp = matrix[2];
        matrix[2] = matrix[6];
        matrix[6] = temp;
        temp = matrix[5];
        matrix[5] = matrix[7];
        matrix[7] = temp;
    }

    static void preSpinMatrix(double[] m1, double[] m2, double angle) {
        double sinAng = Math.sin(angle);
        double cosAng = Math.cos(angle);
        for (int i = 0; i < 9; i += 3) {
            double tval = m1[i] * cosAng - m2[i] * sinAng;
            m2[i] = m2[i] * cosAng + m1[i] * sinAng;
            m1[i] = tval;
        }
    }

    static void spinMatrix(double[] m1, double[] m2, double angle) {
        double sinAng = Math.sin(angle);
        double cosAng = Math.cos(angle);
        for (int i = 0; i < 3; ++i) {
            double tval = m1[i] * cosAng - m2[i] * sinAng;
            m2[i] = m2[i] * cosAng + m1[i] * sinAng;
            m1[i] = tval;
        }
    }
}

