/*
 * Decompiled with CFR 0.152.
 */
package com.mhuss.AstroLib;

import com.mhuss.AstroLib.ATest;
import com.mhuss.AstroLib.TimeOps;
import com.mhuss.Util.Str;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class AstroDate {
    int day;
    int month;
    int year;
    double second;

    public AstroDate() {
        this.day = 1;
        this.month = 1;
        this.year = 2000;
        this.second = 43200.0;
    }

    public AstroDate(int day, int month, int year, int seconds) {
        this.day = day;
        this.month = month;
        this.year = year;
        this.second = seconds;
    }

    public AstroDate(int day, int month, int year, int hour, int min, int sec) {
        this.day = day;
        this.month = month;
        this.year = year;
        this.second = hour * 3600 + min * 60 + sec;
    }

    public AstroDate(int day, int month, int year) {
        this.day = day;
        this.month = month;
        this.year = year;
        this.second = 0.0;
    }

    public AstroDate(int day, int month, int year, double dayFraction) {
        this.day = day;
        this.month = month;
        this.year = year;
        this.second = dayFraction * 86400.0;
    }

    public AstroDate(double jd) {
        double Z = Math.floor(jd += 0.5);
        double F = jd - Z;
        double A = Z;
        if (Z >= 2299161.0) {
            int a = (int)((Z - 1867216.25) / 36525.0);
            A += (double)(1 + a - a / 4);
        }
        double B = A + 1524.0;
        int C = (int)((B - 122.1) / 365.25);
        int D = (int)((double)C * 365.25);
        int E = (int)((B - (double)D) / 30.6001);
        double exactDay = F + B - (double)D - (double)((int)(30.6001 * (double)E));
        this.day = (int)exactDay;
        this.month = E < 14 ? E - 1 : E - 13;
        this.year = C - 4715;
        if (this.month > 2) {
            --this.year;
        }
        this.second = (exactDay - (double)this.day) * 86400.0;
    }

    public static double jd(AstroDate ad, boolean julian) {
        int D = ad.day;
        int M = ad.month;
        int Y = ad.year;
        if (M < 3) {
            --Y;
            M += 12;
        }
        int A = Y / 100;
        int B = julian ? 0 : 2 - A + A / 4;
        double dayFraction = ad.second / 86400.0;
        return dayFraction + (double)((int)(365.25 * (double)(Y + 4716))) + (double)((int)(30.6001 * (double)(M + 1))) + (double)D + (double)B - 1524.5;
    }

    public static double jd(AstroDate ad) {
        return AstroDate.jd(ad, false);
    }

    public double jd(boolean julian) {
        return AstroDate.jd(this, julian);
    }

    public double jd() {
        return AstroDate.jd(this, false);
    }

    public int year() {
        return this.year;
    }

    void setYear(int y) {
        this.year = y;
    }

    public int month() {
        return this.month;
    }

    void setMonth(int m) {
        this.month = m;
    }

    public int day() {
        return this.day;
    }

    void setDay(int d) {
        this.day = d;
    }

    public int hour() {
        return (int)(this.second / 3600.0);
    }

    public int hourRound() {
        return (int)(this.second / 3600.0 + 0.5);
    }

    public int minute() {
        return (int)((this.second - (double)(this.hour() * 3600)) / 60.0);
    }

    public int minuteRound() {
        return (int)((this.second - (double)(this.hour() * 3600)) / 60.0 + 0.5);
    }

    public int second() {
        return (int)(this.second - (double)(this.hour() * 3600) - (double)(this.minute() * 60));
    }

    public GregorianCalendar toGCalendar() {
        return new GregorianCalendar(this.year, this.month - 1, this.day, this.hour(), this.minute(), this.second());
    }

    public String toMinString() {
        return Str.fmt(this.year, 4, '-') + Str.fmt(this.month, '-') + Str.fmt(this.day, ' ') + Str.fmt(this.hour(), ':') + Str.fmt(this.minuteRound());
    }

    public String toMinStringTZ() {
        TimeZone tz = TimeZone.getDefault();
        return this.toMinString() + ' ' + tz.getDisplayName(TimeOps.dstOffset(this.toGCalendar()) != 0, 0);
    }

    public String toString() {
        return "" + Str.fmt(this.year, 4, '-') + Str.fmt(this.month, '-') + Str.fmt(this.day, ' ') + Str.fmt(this.hour(), ':') + Str.fmt(this.minute(), ':') + Str.fmt(this.second());
    }

    public String toStringTZ() {
        TimeZone tz = TimeZone.getDefault();
        return this.toString() + ' ' + tz.getDisplayName(TimeOps.dstOffset(this.toGCalendar()) != 0, 0);
    }

    public static void main(String[] args) {
        System.out.println("AstroDate Test");
        ATest[] at = new ATest[]{new ATest(2000, 1, 1, 0.5, 2451545.0), new ATest(1987, 6, 19, 0.5, 2446966.0), new ATest(1900, 1, 1, 0.0, 2415020.5), new ATest(1600, 12, 31, 0.0, 2305812.5), new ATest(837, 4, 10, 0.3, 2026871.8), new ATest(-1000, 7, 12, 0.5, 1356001.0), new ATest(-4712, 1, 1, 0.5, 0.0)};
        for (int i = 0; i < 7; ++i) {
            AstroDate ad = new AstroDate(at[i].day, at[i].month, at[i].year, at[i].frac);
            double jdm = ad.jd();
            double jdg = 0.0;
            System.out.println("year: " + at[i].year + ", expected: " + at[i].jd + ", jd(m)=" + jdm + ", jd(g)=" + jdg);
        }
    }
}

