/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EmbeddedCatalogResolver
extends DefaultHandler {
    String base;
    String catalogName;
    SAXParserFactory factory;
    HashMap map;

    public EmbeddedCatalogResolver(String catalog, SAXParserFactory factory) {
        int index = catalog.lastIndexOf(47);
        if (index < 0) {
            this.base = "";
            this.catalogName = catalog;
        } else {
            this.base = catalog.substring(0, index + 1);
            this.catalogName = catalog.substring(index + 1);
        }
        this.factory = factory;
        this.map = new HashMap();
    }

    private String getResourceName(String id) throws SAXException {
        try {
            if (id.equals("-//OASIS//DTD Entity Resolution XML Catalog V1.0//EN")) {
                return this.base + "catalog.dtd";
            }
            if (this.map.isEmpty()) {
                InputStream is = this.getClass().getResourceAsStream(this.base + this.catalogName);
                if (is == null) {
                    return null;
                }
                this.factory.newSAXParser().parse(is, (DefaultHandler)this);
            }
            return (String)this.map.get(id);
        }
        catch (ParserConfigurationException pce) {
            throw new SAXException(pce.getMessage());
        }
        catch (IOException ioe) {
            throw new SAXException(ioe.getMessage());
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        String dtdResource = this.getResourceName(publicId);
        if (dtdResource != null) {
            InputStream is = this.getClass().getResourceAsStream(dtdResource);
            return is != null ? new InputSource(is) : null;
        }
        return null;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
        String eltName;
        String string = eltName = localName.equals("") ? qName : localName;
        if (eltName.equals("public")) {
            String publicId = attrs.getValue("publicId");
            String uri = attrs.getValue("uri");
            if (publicId != null && uri != null) {
                this.map.put(publicId, uri.startsWith("/") ? uri : this.base + uri);
            }
        }
    }
}

