/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.rkcheck;

import java.math.BigDecimal;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.spaceroots.rkcheck.QuadraticSurd;

public class QuadraticSurdTest
extends TestCase {
    public QuadraticSurdTest(String name) {
        super(name);
    }

    public void testNullDenominator() {
        try {
            QuadraticSurd f = new QuadraticSurd(1L, 0L);
            QuadraticSurdTest.fail((String)"an exception should have been thrown");
        }
        catch (ArithmeticException f) {
        }
        catch (Exception e) {
            QuadraticSurdTest.fail((String)"wrong exception caught");
        }
    }

    public void testToString() {
        this.checkValue(new QuadraticSurd(1L, 2L), "1 / 2");
        this.checkValue(new QuadraticSurd(-1L, 2L), "-1 / 2");
        this.checkValue(new QuadraticSurd(1L, -2L), "-1 / 2");
        this.checkValue(new QuadraticSurd(-1L, -2L), "1 / 2");
        this.checkValue(new QuadraticSurd(0L, 500L), "0");
        this.checkValue(new QuadraticSurd(-12L), "-12");
        this.checkValue(new QuadraticSurd(12L), "12");
    }

    public void testSimplification() {
        this.checkValue(new QuadraticSurd(2L, 4L), "1 / 2");
        this.checkValue(new QuadraticSurd(307692L, 999999L), "4 / 13");
        this.checkValue(new QuadraticSurd(999999L, 307692L), "13 / 4");
    }

    public void testInvert() {
        QuadraticSurd f = new QuadraticSurd(2L, 4L);
        f.invertSelf();
        this.checkValue(f, "2");
        f.invertSelf();
        this.checkValue(f, "1 / 2");
        f = new QuadraticSurd(120L);
        f.invertSelf();
        this.checkValue(f, "1 / 120");
        f = new QuadraticSurd(0L, 4L);
        try {
            f.invertSelf();
            QuadraticSurdTest.fail((String)"an exception should have been thrown");
        }
        catch (ArithmeticException arithmeticException) {
        }
        catch (Exception e) {
            QuadraticSurdTest.fail((String)"wrong exception caught");
        }
        f = new QuadraticSurd(307692L, 999999L);
        QuadraticSurd fInverse = QuadraticSurd.invert(f);
        this.checkValue(fInverse, "13 / 4");
        this.checkValue(f, "4 / 13");
        f = new QuadraticSurd(1L, 2L, 3L, 4L);
        this.checkValue(QuadraticSurd.invert(f), "(-4 + 8 sqrt(3)) / 11");
    }

    public void testAddition() {
        QuadraticSurd f1 = new QuadraticSurd(4L, 6L);
        f1.addToSelf(f1);
        this.checkValue(f1, "4 / 3");
        this.checkValue(QuadraticSurd.add(new QuadraticSurd(17L, 3L), new QuadraticSurd(-17L, 3L)), "0");
        this.checkValue(QuadraticSurd.add(new QuadraticSurd(2L, 3L), new QuadraticSurd(3L, 4L)), "17 / 12");
        this.checkValue(QuadraticSurd.add(new QuadraticSurd(1L, 6L), new QuadraticSurd(2L, 6L)), "1 / 2");
        this.checkValue(QuadraticSurd.add(new QuadraticSurd(4L, 5L), new QuadraticSurd(-3L, 4L)), "1 / 20");
        this.checkValue(QuadraticSurd.add(new QuadraticSurd(-3L, 4L), new QuadraticSurd(4L, 5L)), "1 / 20");
    }

    public void testSubtraction() {
        QuadraticSurd f1 = new QuadraticSurd(4L, 6L);
        f1.subtractFromSelf(f1);
        this.checkValue(f1, "0");
        this.checkValue(QuadraticSurd.subtract(new QuadraticSurd(7L, 3L), new QuadraticSurd(-7L, 3L)), "14 / 3");
        this.checkValue(QuadraticSurd.subtract(new QuadraticSurd(3L, 4L), new QuadraticSurd(2L, 3L)), "1 / 12");
        this.checkValue(QuadraticSurd.subtract(new QuadraticSurd(3L, 4L), new QuadraticSurd(-2L, 3L)), "17 / 12");
        this.checkValue(QuadraticSurd.subtract(new QuadraticSurd(-3L, 4L), new QuadraticSurd(2L, 3L)), "-17 / 12");
        this.checkValue(QuadraticSurd.subtract(new QuadraticSurd(-3L, 4L), new QuadraticSurd(-2L, 3L)), "-1 / 12");
        this.checkValue(QuadraticSurd.subtract(new QuadraticSurd(2L, 3L), new QuadraticSurd(3L, 4L)), "-1 / 12");
        this.checkValue(QuadraticSurd.subtract(new QuadraticSurd(-2L, 3L), new QuadraticSurd(3L, 4L)), "-17 / 12");
        this.checkValue(QuadraticSurd.subtract(new QuadraticSurd(2L, 3L), new QuadraticSurd(-3L, 4L)), "17 / 12");
        this.checkValue(QuadraticSurd.subtract(new QuadraticSurd(-2L, 3L), new QuadraticSurd(-3L, 4L)), "1 / 12");
        this.checkValue(QuadraticSurd.subtract(new QuadraticSurd(1L, 6L), new QuadraticSurd(2L, 6L)), "-1 / 6");
        this.checkValue(QuadraticSurd.subtract(new QuadraticSurd(1L, 2L), new QuadraticSurd(1L, 6L)), "1 / 3");
    }

    public void testMultiplication() {
        QuadraticSurd f = new QuadraticSurd(2L, 3L);
        f.multiplySelf(new QuadraticSurd(9L, 4L));
        this.checkValue(f, "3 / 2");
        this.checkValue(QuadraticSurd.multiply(new QuadraticSurd(1L, 2L), new QuadraticSurd(0L)), "0");
        this.checkValue(QuadraticSurd.multiply(new QuadraticSurd(4L, 15L), new QuadraticSurd(-5L, 2L)), "-2 / 3");
        this.checkValue(QuadraticSurd.multiply(new QuadraticSurd(-4L, 15L), new QuadraticSurd(5L, 2L)), "-2 / 3");
        this.checkValue(QuadraticSurd.multiply(new QuadraticSurd(4L, 15L), new QuadraticSurd(5L, 2L)), "2 / 3");
        this.checkValue(QuadraticSurd.multiply(new QuadraticSurd(-4L, 15L), new QuadraticSurd(-5L, 2L)), "2 / 3");
        QuadraticSurd qs1 = new QuadraticSurd(1L, 2L, 5L, 3L);
        QuadraticSurd qs2 = new QuadraticSurd(3L, -1L, 5L, 2L);
        this.checkValue(QuadraticSurd.multiply(qs1, qs2), "(-7 + 5 sqrt(5)) / 6");
        qs1 = new QuadraticSurd(2L, -3L, 11L, 5L);
        qs2 = new QuadraticSurd(2L, 3L, 11L, 19L);
        QuadraticSurdTest.assertTrue((boolean)QuadraticSurd.negate(QuadraticSurd.multiply(qs1, qs2)).isOne());
    }

    public void testDivision() {
        QuadraticSurd f = new QuadraticSurd(2L, 3L);
        f.divideSelf(new QuadraticSurd(4L, 9L));
        this.checkValue(f, "3 / 2");
        try {
            QuadraticSurd.divide(new QuadraticSurd(1L, 2L), new QuadraticSurd(0L));
            QuadraticSurdTest.fail((String)"an exception should have been thrown");
        }
        catch (ArithmeticException arithmeticException) {
        }
        catch (Exception e) {
            QuadraticSurdTest.fail((String)"wrong exception caught");
        }
        this.checkValue(QuadraticSurd.divide(new QuadraticSurd(4L, 15L), new QuadraticSurd(-2L, 5L)), "-2 / 3");
        this.checkValue(QuadraticSurd.divide(new QuadraticSurd(-4L, 15L), new QuadraticSurd(2L, 5L)), "-2 / 3");
        this.checkValue(QuadraticSurd.divide(new QuadraticSurd(4L, 15L), new QuadraticSurd(2L, 5L)), "2 / 3");
        this.checkValue(QuadraticSurd.divide(new QuadraticSurd(-4L, 15L), new QuadraticSurd(-2L, 5L)), "2 / 3");
        this.checkValue(QuadraticSurd.divide(new QuadraticSurd(2L, 5L, 2L, 3L), new QuadraticSurd(1L, 4L, 2L, 2L)), "(76 + 6 sqrt(2)) / 93");
    }

    public void testDormandPrince() {
        QuadraticSurd r = new QuadraticSurd(0L);
        r.addToSelf(new QuadraticSurd(104257L, 1920240L));
        r.addToSelf(new QuadraticSurd(3399327L, 763840L));
        r.addToSelf(new QuadraticSurd(66578432L, 35198415L));
        r.addToSelf(new QuadraticSurd(-1674902723L, 288716400L));
        r.addToSelf(new QuadraticSurd(54980371265625L, 176692375811392L));
        r.addToSelf(new QuadraticSurd(-734375L, 4826304L));
        r.addToSelf(new QuadraticSurd(171414593L, 851261400L));
        r.addToSelf(new QuadraticSurd(137909L, 3084480L));
        this.checkValue(r, "1");
    }

    public void testDifferentFields() {
        try {
            QuadraticSurd.add(new QuadraticSurd(1L, 2L, 3L, 4L), new QuadraticSurd(4L, 3L, 2L, 1L));
            QuadraticSurdTest.fail((String)"an exception should have been thrown");
        }
        catch (ArithmeticException arithmeticException) {
        }
        catch (Exception e) {
            QuadraticSurdTest.fail((String)"wrong exception caught");
        }
    }

    public void testApproximation() {
        BigDecimal minusPi = new BigDecimal(-Math.PI);
        this.checkValue(new QuadraticSurd(minusPi, new BigDecimal(0.2)), "-3");
        this.checkValue(new QuadraticSurd(minusPi, new BigDecimal(0.01)), "-22 / 7");
        this.checkValue(new QuadraticSurd(minusPi, new BigDecimal(1.0E-4)), "-333 / 106");
        this.checkValue(new QuadraticSurd(minusPi, new BigDecimal(1.0E-6)), "-355 / 113");
        this.checkValue(new QuadraticSurd(minusPi, new BigDecimal(1.0E-9)), "-103993 / 33102");
    }

    private void checkValue(QuadraticSurd f, String reference) {
        QuadraticSurdTest.assertTrue((boolean)f.toString().equals(reference));
    }

    public static Test suite() {
        return new TestSuite(QuadraticSurdTest.class);
    }
}

