/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.rkcheck;

import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import org.spaceroots.rkcheck.QuadraticSurd;

public class DerivationTree
implements Comparable {
    private Vector subtrees;
    private static final char[] labels = new char[]{'i', 'j', 'k', 'l', 'm', 'p', 'q', 'r', 'u', 'v', 'w', 'e', 'f', 'g'};

    public DerivationTree() {
        this.subtrees = null;
    }

    public DerivationTree(DerivationTree tree) {
        if (tree.isLeaf()) {
            this.subtrees = null;
        } else {
            this.subtrees = new Vector(tree.subtrees.size());
            Iterator iter = tree.subtrees.iterator();
            while (iter.hasNext()) {
                this.subtrees.add(new DerivationTree((DerivationTree)iter.next()));
            }
        }
    }

    public DerivationTree(DerivationTree[] trees) {
        if (trees == null) {
            this.subtrees = null;
        } else {
            this.subtrees = new Vector(trees.length);
            for (int i = 0; i < trees.length; ++i) {
                if (trees[i] == null) continue;
                this.subtrees.add(new DerivationTree(trees[i]));
            }
            Collections.sort(this.subtrees);
        }
    }

    public Vector listUpperTrees() {
        Vector<DerivationTree> list = new Vector<DerivationTree>();
        if (this.isLeaf()) {
            DerivationTree[] array = new DerivationTree[]{new DerivationTree()};
            list.add(new DerivationTree(array));
        } else {
            int i;
            DerivationTree[] array = new DerivationTree[this.subtrees.size() + 1];
            array[0] = new DerivationTree();
            for (i = 0; i < this.subtrees.size(); ++i) {
                array[i + 1] = (DerivationTree)this.subtrees.elementAt(i);
            }
            list.add(new DerivationTree(array));
            array = this.subtrees.toArray(array);
            for (i = 0; i < this.subtrees.size(); ++i) {
                DerivationTree dt = array[i];
                Vector upperSub = dt.listUpperTrees();
                Iterator iter = upperSub.iterator();
                while (iter.hasNext()) {
                    array[i] = (DerivationTree)iter.next();
                    list.add(new DerivationTree(array));
                }
                array[i] = dt;
            }
        }
        return list;
    }

    public boolean isLeaf() {
        return this.subtrees == null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DerivationTree)) {
            return false;
        }
        if (this.subtrees == null) {
            return ((DerivationTree)o).subtrees == null;
        }
        if (((DerivationTree)o).subtrees == null) {
            return false;
        }
        Iterator iter1 = this.subtrees.iterator();
        Iterator iter2 = ((DerivationTree)o).subtrees.iterator();
        while (iter1.hasNext()) {
            if (!iter2.hasNext()) {
                return false;
            }
            if (((DerivationTree)iter1.next()).equals(iter2.next())) continue;
            return false;
        }
        return !iter2.hasNext();
    }

    public int hashCode() {
        if (this.isLeaf()) {
            return 1;
        }
        int n = 0;
        Iterator iter = this.subtrees.iterator();
        while (iter.hasNext()) {
            n = n << 4 ^ ((DerivationTree)iter.next()).hashCode();
        }
        return n;
    }

    public int compareTo(Object o) {
        int sub2;
        int order2;
        DerivationTree dt = (DerivationTree)o;
        int order1 = this.getOrder();
        if (order1 != (order2 = dt.getOrder())) {
            return order1 - order2;
        }
        if (this.isLeaf()) {
            return 0;
        }
        int sub1 = this.subtrees.size();
        if (sub1 != (sub2 = dt.subtrees.size())) {
            return sub1 - sub2;
        }
        for (int i = 0; i < sub1; ++i) {
            DerivationTree dt2;
            DerivationTree dt1 = (DerivationTree)this.subtrees.elementAt(i);
            int result = dt1.compareTo(dt2 = (DerivationTree)dt.subtrees.elementAt(i));
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public int getDepth() {
        if (this.isLeaf()) {
            return 0;
        }
        int maxDepth = 0;
        Iterator iter = this.subtrees.iterator();
        while (iter.hasNext()) {
            maxDepth = Math.max(maxDepth, ((DerivationTree)iter.next()).getDepth());
        }
        return maxDepth + 1;
    }

    public int getOrder() {
        if (this.isLeaf()) {
            return 1;
        }
        int order = 1;
        Iterator iter = this.subtrees.iterator();
        while (iter.hasNext()) {
            order += ((DerivationTree)iter.next()).getOrder();
        }
        return order;
    }

    public long getFactorial() {
        if (this.isLeaf()) {
            return 1L;
        }
        long factorial = this.getOrder();
        Iterator iter = this.subtrees.iterator();
        while (iter.hasNext()) {
            factorial *= ((DerivationTree)iter.next()).getFactorial();
        }
        return factorial;
    }

    public QuadraticSurd getAlpha() {
        if (this.isLeaf()) {
            return new QuadraticSurd(1L);
        }
        QuadraticSurd alpha = this.deltaOnFact();
        Iterator iter = this.subtrees.iterator();
        while (iter.hasNext()) {
            alpha.multiplySelf(((DerivationTree)iter.next()).getAlpha());
        }
        return alpha;
    }

    public QuadraticSurd orderConditionResidual(QuadraticSurd[] c, QuadraticSurd[][] a, QuadraticSurd[] b) {
        QuadraticSurd left = new QuadraticSurd(0L);
        QuadraticSurd[] table = this.contribution(c, a);
        for (int i = 0; i < b.length; ++i) {
            left.addToSelf(QuadraticSurd.multiply(b[i], table[i]));
        }
        QuadraticSurd right = new QuadraticSurd(1L, this.getFactorial());
        return QuadraticSurd.subtract(left, right);
    }

    private QuadraticSurd[] contribution(QuadraticSurd[] c, QuadraticSurd[][] a) {
        QuadraticSurd[] table = new QuadraticSurd[c.length];
        for (int k = 0; k < table.length; ++k) {
            table[k] = new QuadraticSurd(1L);
        }
        if (this.isLeaf()) {
            return table;
        }
        for (int i = 0; i < this.subtrees.size(); ++i) {
            int k;
            DerivationTree tree = (DerivationTree)this.subtrees.elementAt(i);
            QuadraticSurd[] sum = new QuadraticSurd[c.length];
            int exp = 1;
            while (i + 1 < this.subtrees.size() && tree.equals(this.subtrees.elementAt(i + 1))) {
                ++exp;
                ++i;
            }
            if (tree.isLeaf()) {
                for (int k2 = 0; k2 < sum.length; ++k2) {
                    sum[k2] = c[k2];
                }
            } else {
                QuadraticSurd[] sub = tree.contribution(c, a);
                for (k = 0; k < sum.length; ++k) {
                    sum[k] = new QuadraticSurd(0L);
                    for (int j = 0; j < k; ++j) {
                        sum[k].addToSelf(QuadraticSurd.multiply(a[k][j], sub[j]));
                    }
                }
            }
            for (int j = 0; j < exp; ++j) {
                for (k = 0; k < sum.length; ++k) {
                    table[k].multiplySelf(sum[k]);
                }
            }
        }
        return table;
    }

    public String orderConditionAsTeXString(boolean interpolatorCondition) {
        int order = this.getOrder();
        String numerator = interpolatorCondition && order > 1 ? "\\theta" + (order > 2 ? "^{" + (order - 1) + "}" : "") : "1";
        return "\\sum_{i=" + Math.max(1, this.getDepth()) + "}^{i=s}\\left(b_{i} " + this.contributionAsTeXString(0) + "\\right) =" + (this.getFactorial() == 1L ? numerator : " \\frac{" + numerator + "}{" + this.getFactorial() + "}");
    }

    private String contributionAsTeXString(int index) {
        if (this.isLeaf()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.subtrees.size(); ++i) {
            DerivationTree tree = (DerivationTree)this.subtrees.elementAt(i);
            int exp = 1;
            while (i + 1 < this.subtrees.size() && tree.equals(this.subtrees.elementAt(i + 1))) {
                ++exp;
                ++i;
            }
            if (tree.isLeaf()) {
                sb.append("c_{");
                sb.append(labels[index]);
                sb.append("}");
            } else {
                if (exp != 1) {
                    sb.append("\\left(");
                }
                sb.append("\\sum_{");
                sb.append(labels[index + 1]);
                sb.append("=");
                sb.append(Math.max(1, tree.getDepth()));
                sb.append("}^{");
                sb.append(labels[index + 1]);
                sb.append("=");
                sb.append(labels[index]);
                sb.append("-1}{\\left(a_{");
                sb.append(labels[index]);
                sb.append(",");
                sb.append(labels[index + 1]);
                sb.append("} ");
                sb.append(tree.contributionAsTeXString(index + 1));
                sb.append(" \\right)}");
                if (exp != 1) {
                    sb.append(" \\right)");
                }
            }
            if (exp == 1) continue;
            sb.append("^{");
            sb.append(Integer.toString(exp));
            sb.append("}");
        }
        return sb.toString();
    }

    public String orderConditionAsMaximaString(boolean interpolatorCondition) {
        int order = this.getOrder();
        String numerator = interpolatorCondition && order > 1 ? "theta" + (order > 2 ? "^" + (order - 1) : "") : "1";
        return "sum(b[i]" + this.contributionAsMaximaString(0) + ",i," + Math.max(1, this.getDepth()) + ",s) = " + (this.getFactorial() == 1L ? numerator : numerator + " / " + this.getFactorial());
    }

    private String contributionAsMaximaString(int index) {
        if (this.isLeaf()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.subtrees.size(); ++i) {
            DerivationTree tree = (DerivationTree)this.subtrees.elementAt(i);
            int exp = 1;
            while (i + 1 < this.subtrees.size() && tree.equals(this.subtrees.elementAt(i + 1))) {
                ++exp;
                ++i;
            }
            sb.append(" * ");
            if (tree.isLeaf()) {
                sb.append("t[");
                sb.append(labels[index]);
                sb.append("]");
            } else {
                if (exp != 1) {
                    sb.append("(");
                }
                sb.append("sum(");
                sb.append("(a[");
                sb.append(labels[index]);
                sb.append(",");
                sb.append(labels[index + 1]);
                sb.append("]");
                sb.append(tree.contributionAsMaximaString(index + 1));
                sb.append("),");
                sb.append(labels[index + 1]);
                sb.append(",");
                sb.append(Math.max(1, tree.getDepth()));
                sb.append(",");
                sb.append(labels[index]);
                sb.append("-1)");
                if (exp != 1) {
                    sb.append(")");
                }
            }
            if (exp == 1) continue;
            sb.append("^");
            sb.append(Integer.toString(exp));
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("f");
        if (!this.isLeaf()) {
            for (int i = 0; i < this.subtrees.size(); ++i) {
                sb.append('\'');
            }
            sb.append('(');
            Iterator iter = this.subtrees.iterator();
            while (iter.hasNext()) {
                sb.append(((DerivationTree)iter.next()).toString());
                if (!iter.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(")");
        }
        return sb.toString();
    }

    private QuadraticSurd deltaOnFact() {
        int i;
        int[] countSame = new int[this.subtrees.size()];
        for (i = 0; i < countSame.length; ++i) {
            countSame[i] = 0;
        }
        for (i = 0; i < this.subtrees.size(); ++i) {
            DerivationTree dt = (DerivationTree)this.subtrees.elementAt(i);
            boolean stillLooking = true;
            for (int j = 0; stillLooking && j < i; ++j) {
                if (countSame[j] <= 0 || !dt.equals((DerivationTree)this.subtrees.elementAt(j))) continue;
                int n = j;
                countSame[n] = countSame[n] + 1;
                stillLooking = false;
            }
            if (!stillLooking) continue;
            countSame[i] = 1;
        }
        QuadraticSurd q = new QuadraticSurd(1L);
        for (int i2 = 0; i2 < countSame.length; ++i2) {
            if (countSame[i2] <= 1) continue;
            q.divideSelf(DerivationTree.fact(countSame[i2]));
        }
        return q;
    }

    private static long fact(int n) {
        long f = 1L;
        while (n > 1) {
            f *= (long)n--;
        }
        return f;
    }
}

