/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.rkcheck;

import java.io.IOException;
import java.util.TreeSet;
import javax.xml.parsers.FactoryConfigurationError;
import org.spaceroots.rkcheck.DerivationTree;
import org.spaceroots.rkcheck.DerivationTreesSetGenerator;
import org.spaceroots.rkcheck.QuadraticSurd;
import org.spaceroots.rkcheck.RKCheckException;
import org.spaceroots.rkcheck.RungeKuttaFile;
import org.spaceroots.rkcheck.RungeKuttaMethod;

public class CheckOrderConditions {
    private static String checkHomogeneityConditions(QuadraticSurd[] c, QuadraticSurd[][] a, double tolerance) {
        StringBuffer sb = new StringBuffer();
        if (!c[0].isZero() && Math.abs(c[0].doubleValue()) > tolerance) {
            sb.append("c[1] = ");
            if (tolerance <= 0.0) {
                sb.append(c[0].toString());
            } else {
                sb.append(c[0].doubleValue());
            }
            sb.append(" (should be null)");
        }
        for (int i = 1; i < c.length; ++i) {
            QuadraticSurd sum = new QuadraticSurd(0L);
            for (int j = 0; j < i; ++j) {
                sum.addToSelf(a[i][j]);
            }
            QuadraticSurd delta = QuadraticSurd.subtract(c[i], sum);
            if (delta.isZero() || !(Math.abs(delta.doubleValue()) > tolerance)) continue;
            if (sb.length() != 0) {
                sb.append(System.getProperty("line.separator"));
            }
            sb.append("c[");
            sb.append(i + 1);
            sb.append("] - sum(a[");
            sb.append(i + 1);
            sb.append("][j]) = ");
            if (tolerance <= 0.0) {
                sb.append(delta.toString());
            } else {
                sb.append(delta.doubleValue());
            }
            sb.append(" (should be null)");
        }
        return sb.toString();
    }

    private static String checkOrderConditions(DerivationTreesSetGenerator generator, QuadraticSurd[] c, QuadraticSurd[][] a, QuadraticSurd[] b, double tolerance, boolean verbose) {
        int order = 1;
        StringBuffer sb = new StringBuffer();
        while (sb.length() == 0) {
            TreeSet set = generator.getTreesSet(order);
            for (DerivationTree dt : set) {
                QuadraticSurd residual = dt.orderConditionResidual(c, a, b);
                if (residual.isZero() || !(Math.abs(residual.doubleValue()) > tolerance)) continue;
                if (sb.length() == 0) {
                    sb.append(" is of order " + (order - 1));
                }
                if (!verbose) continue;
                sb.append(System.getProperty("line.separator"));
                sb.append("residual for tree " + dt.toString() + " = ");
                if (tolerance <= 0.0) {
                    sb.append(residual.toString());
                    continue;
                }
                sb.append(residual.doubleValue());
            }
            ++order;
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        try {
            String uri = null;
            boolean verbose = false;
            double tolerance = -1.0;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-help")) {
                    CheckOrderConditions.usage(0);
                    continue;
                }
                if (args[i].equals("-verbose")) {
                    verbose = true;
                    continue;
                }
                if (args[i].equals("-tolerance")) {
                    if (++i == args.length) {
                        System.err.println("missing argument for -tolerance switch");
                        CheckOrderConditions.usage(1);
                    }
                    tolerance = Double.parseDouble(args[i]);
                    continue;
                }
                uri = args[i];
            }
            if (uri == null) {
                CheckOrderConditions.usage(1);
            }
            RungeKuttaMethod method = new RungeKuttaMethod();
            new RungeKuttaFile(method).read(uri);
            CheckOrderConditions.checkHomogeneityConditions(method.getTimeSteps(), method.getInternalWeights(), tolerance);
            DerivationTreesSetGenerator generator = new DerivationTreesSetGenerator();
            System.out.print(method.getName() + " method");
            System.out.println(CheckOrderConditions.checkOrderConditions(generator, method.getTimeSteps(), method.getInternalWeights(), method.getEstimationWeights(), tolerance, verbose));
            QuadraticSurd[] e = method.getErrorWeights();
            if (e != null) {
                QuadraticSurd[] b = method.getEstimationWeights();
                QuadraticSurd[] bHat = new QuadraticSurd[b.length];
                for (int i = 0; i < bHat.length; ++i) {
                    bHat[i] = QuadraticSurd.add(b[i], e[i]);
                }
                System.out.print("error estimation");
                System.out.println(CheckOrderConditions.checkOrderConditions(generator, method.getTimeSteps(), method.getInternalWeights(), bHat, tolerance, verbose));
            }
        }
        catch (NumberFormatException nfe) {
            System.err.println("error parsing number: " + nfe.getMessage());
            System.exit(1);
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
            System.exit(1);
        }
        catch (FactoryConfigurationError fce) {
            System.err.println(fce.getMessage());
            System.exit(1);
        }
        catch (RKCheckException rke) {
            System.err.println(rke.getMessage());
            System.exit(1);
        }
    }

    private static void usage(int exit) {
        System.out.println("usage: java CheckOrderConditions [-help] [-verbose] [-tolerance t] uri");
        System.exit(exit);
    }
}

