/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.mantissa.linalg;

import org.spaceroots.mantissa.linalg.DiagonalMatrix;
import org.spaceroots.mantissa.linalg.GeneralMatrix;
import org.spaceroots.mantissa.linalg.GeneralSquareMatrix;
import org.spaceroots.mantissa.linalg.LowerTriangularMatrix;
import org.spaceroots.mantissa.linalg.Matrix;
import org.spaceroots.mantissa.linalg.UpperTriangularMatrix;

public class MatrixFactory {
    private MatrixFactory() {
    }

    public static Matrix buildMatrix(int rows, int columns, double[] data, int lowerElements, int upperElements) {
        if (rows == columns) {
            if (lowerElements == 0 && upperElements == 0) {
                return new DiagonalMatrix(rows, data);
            }
            if (lowerElements == 0) {
                return new UpperTriangularMatrix(rows, data);
            }
            if (upperElements == 0) {
                return new LowerTriangularMatrix(rows, data);
            }
            return new GeneralSquareMatrix(rows, data);
        }
        return new GeneralMatrix(rows, columns, data);
    }

    public static Matrix buildMatrix(int rows, int columns, double[] data) {
        if (rows == columns) {
            return new GeneralSquareMatrix(rows, data);
        }
        return new GeneralMatrix(rows, columns, data);
    }
}

