/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.stochprocess;

import umontreal.iro.lecuyer.randvar.NormalGen;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.stochprocess.BrownianMotion;
import umontreal.iro.lecuyer.stochprocess.StochasticProcess;

public class GeometricBrownianMotion
extends StochasticProcess {
    protected NormalGen gen;
    protected BrownianMotion bm;
    protected double mu;
    protected double sigma;
    protected double[] mudt;

    public GeometricBrownianMotion(double s0, double mu, double sigma, RandomStream stream) {
        this(s0, mu, sigma, new BrownianMotion(0.0, 0.0, 1.0, stream));
    }

    public GeometricBrownianMotion(double s0, double mu, double sigma, BrownianMotion bm) {
        this.bm = bm;
        this.setParams(s0, mu, sigma);
    }

    @Override
    public void setObservationTimes(double[] t, int d) {
        this.d = d;
        super.setObservationTimes(t, d);
        this.bm.setObservationTimes(t, d);
    }

    @Override
    public double nextObservation() {
        double s = this.x0 * Math.exp(this.bm.nextObservation());
        this.observationIndex = this.bm.getCurrentObservationIndex();
        this.path[this.observationIndex] = s;
        return s;
    }

    @Override
    public double[] generatePath() {
        this.path[0] = this.x0;
        this.bm.generatePath();
        for (int i = 1; i <= this.d; ++i) {
            this.path[i] = this.x0 * Math.exp(this.bm.getObservation(i));
        }
        this.observationCounter = this.d;
        return this.path;
    }

    @Override
    public double[] generatePath(RandomStream stream) {
        this.setStream(stream);
        return this.generatePath();
    }

    @Override
    public void resetStartProcess() {
        this.observationCounter = 0;
        this.bm.resetStartProcess();
    }

    public void setParams(double s0, double mu, double sigma) {
        this.x0 = s0;
        this.mu = mu;
        this.sigma = sigma;
        this.bm.setParams(0.0, mu - 0.5 * sigma * sigma, sigma);
        if (this.observationTimesSet) {
            this.init();
        }
    }

    @Override
    public void setStream(RandomStream stream) {
        this.bm.gen.setStream(stream);
    }

    @Override
    public RandomStream getStream() {
        return this.bm.gen.getStream();
    }

    public double getMu() {
        return this.mu;
    }

    public double getSigma() {
        return this.sigma;
    }

    public NormalGen getGen() {
        return this.gen;
    }

    public BrownianMotion getBrownianMotion() {
        return this.bm;
    }

    @Override
    protected void init() {
        super.init();
    }
}

