/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.rng;

import cern.colt.list.DoubleArrayList;
import umontreal.iro.lecuyer.rng.RandomStream;

public class RandomStreamWithCache
implements RandomStream {
    private RandomStream stream;
    private DoubleArrayList values;
    private int index = 0;
    private boolean caching = true;

    public RandomStreamWithCache(RandomStream stream) {
        if (stream == null) {
            throw new NullPointerException("The given random stream cannot be null");
        }
        this.stream = stream;
        this.values = new DoubleArrayList();
    }

    public RandomStreamWithCache(RandomStream stream, int initialCapacity) {
        if (stream == null) {
            throw new NullPointerException("The given random stream cannot be null");
        }
        this.stream = stream;
        this.values = new DoubleArrayList(initialCapacity);
    }

    public boolean isCaching() {
        return this.caching;
    }

    public void setCaching(boolean caching) {
        if (this.caching && !caching) {
            this.clearCache();
        }
        this.caching = caching;
    }

    public RandomStream getCachedStream() {
        return this.stream;
    }

    public void setCachedStream(RandomStream stream) {
        if (stream == null) {
            throw new NullPointerException("The given random stream cannot be null");
        }
        if (stream == this.stream) {
            return;
        }
        this.stream = stream;
        this.clearCache();
    }

    public void clearCache() {
        this.values = new DoubleArrayList();
        this.index = 0;
    }

    public void initCache() {
        this.index = 0;
    }

    public int getNumCachedValues() {
        return this.values.size();
    }

    public int getCacheIndex() {
        return this.index;
    }

    public void setCacheIndex(int newIndex) {
        if (newIndex < 0 || newIndex > this.values.size()) {
            throw new IllegalArgumentException("newIndex must not be negative or greater than the cache size");
        }
        this.index = newIndex;
    }

    public DoubleArrayList getCachedValues() {
        return this.values;
    }

    public void setCachedValues(DoubleArrayList values) {
        if (values == null) {
            throw new NullPointerException();
        }
        this.values = values;
        this.index = values.size();
    }

    @Override
    public void resetStartStream() {
        this.stream.resetStartStream();
    }

    @Override
    public void resetStartSubstream() {
        this.stream.resetStartSubstream();
    }

    @Override
    public void resetNextSubstream() {
        this.stream.resetNextSubstream();
    }

    @Override
    public double nextDouble() {
        if (!this.caching) {
            return this.stream.nextDouble();
        }
        if (this.index >= this.values.size()) {
            double v = this.stream.nextDouble();
            this.values.add(v);
            ++this.index;
            return v;
        }
        return this.values.getQuick(this.index++);
    }

    @Override
    public void nextArrayOfDouble(double[] u, int start, int n) {
        int ngen;
        int ncpy;
        if (!this.caching) {
            this.stream.nextArrayOfDouble(u, start, n);
            return;
        }
        int remainingValues = this.values.size() - this.index;
        if (remainingValues < 0) {
            remainingValues = 0;
        }
        if ((ncpy = Math.min(n, remainingValues)) > 0) {
            System.arraycopy(this.values.elements(), this.index, u, start, ncpy);
            this.index += ncpy;
        }
        if ((ngen = n - ncpy) > 0) {
            this.stream.nextArrayOfDouble(u, start + ncpy, ngen);
            for (int i = ncpy; i < n; ++i) {
                this.values.add(u[start + i]);
                ++this.index;
            }
        }
    }

    @Override
    public int nextInt(int i, int j) {
        return i + (int)(this.nextDouble() * (double)(j - i + 1));
    }

    @Override
    public void nextArrayOfInt(int i, int j, int[] u, int start, int n) {
        for (int x = start; x < start + n; ++x) {
            u[x] = this.nextInt(i, j);
        }
    }
}

