/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.DiscreteDistributionInt;
import umontreal.iro.lecuyer.probdist.GammaDist;
import umontreal.iro.lecuyer.util.Num;

public class PoissonDist
extends DiscreteDistributionInt {
    private double lambda;
    public static double MAXLAMBDA = 100000.0;

    public PoissonDist(double lambda) {
        this.setLambda(lambda);
    }

    @Override
    public double prob(int x) {
        if (x < 0) {
            return 0.0;
        }
        if (this.pdf == null) {
            return PoissonDist.prob(this.lambda, x);
        }
        if (x > this.xmax || x < this.xmin) {
            return PoissonDist.prob(this.lambda, x);
        }
        return this.pdf[x - this.xmin];
    }

    @Override
    public double cdf(int x) {
        double Sum = 0.0;
        if (x < 0) {
            return 0.0;
        }
        if (this.lambda == 0.0) {
            return 1.0;
        }
        if (this.cdf == null) {
            return GammaDist.barF((double)x + 1.0, 15, this.lambda);
        }
        if (x >= this.xmax) {
            return 1.0;
        }
        if (x < this.xmin) {
            double term;
            int RMAX = 20;
            Sum = term = PoissonDist.prob(this.lambda, x);
            int i = x;
            while (i > 0 && i >= x - 20) {
                term = term * (double)i / this.lambda;
                --i;
                Sum += term;
            }
            return Sum;
        }
        if (x <= this.xmed) {
            return this.cdf[x - this.xmin];
        }
        return 1.0 - this.cdf[x + 1 - this.xmin];
    }

    @Override
    public double barF(int x) {
        if (x <= 0) {
            return 1.0;
        }
        if (this.cdf == null) {
            return GammaDist.cdf(x, 15, this.lambda);
        }
        if (x > this.xmax) {
            return PoissonDist.barF(this.lambda, x);
        }
        if (x <= this.xmin) {
            return 1.0;
        }
        if (x > this.xmed) {
            return this.cdf[x - this.xmin];
        }
        return 1.0 - this.cdf[x - 1 - this.xmin];
    }

    @Override
    public int inverseFInt(double u) {
        if (this.cdf == null) {
            return PoissonDist.inverseF(this.lambda, u);
        }
        return super.inverseFInt(u);
    }

    @Override
    public double getMean() {
        return PoissonDist.getMean(this.lambda);
    }

    @Override
    public double getVariance() {
        return PoissonDist.getVariance(this.lambda);
    }

    @Override
    public double getStandardDeviation() {
        return PoissonDist.getStandardDeviation(this.lambda);
    }

    public static double prob(double lambda, int x) {
        double Res;
        double LAMBDALIM = 20.0;
        if (x < 0) {
            return 0.0;
        }
        if (lambda >= 100.0 ? (double)x >= 10.0 * lambda : (lambda >= 3.0 ? (double)x >= 100.0 * lambda : (double)x >= 200.0 * Math.max(1.0, lambda))) {
            return 0.0;
        }
        if (lambda < 20.0 && x <= 100) {
            Res = Math.exp(-lambda) * Math.pow(lambda, x) / Num.factorial(x);
        } else {
            double y = (double)x * Math.log(lambda) - Num.lnGamma((double)x + 1.0) - lambda;
            Res = Math.exp(y);
        }
        return Res;
    }

    public static double cdf(double lambda, int x) {
        double term;
        double LAMBDALIM = 200.0;
        if (lambda < 0.0) {
            throw new IllegalArgumentException("lambda < 0");
        }
        if (lambda == 0.0) {
            return 1.0;
        }
        if (x < 0) {
            return 0.0;
        }
        if (lambda >= 100.0 ? (double)x >= 10.0 * lambda : (double)x >= 100.0 * Math.max(1.0, lambda)) {
            return 1.0;
        }
        if (lambda > 200.0) {
            return GammaDist.barF((double)x + 1.0, 15, lambda);
        }
        if ((double)x >= lambda) {
            return 1.0 - PoissonDist.barF(lambda, x + 1);
        }
        double sum = term = PoissonDist.prob(lambda, x);
        for (int i = x; term > EPSILON && i > 0; term *= (double)i / lambda, --i) {
        }
        sum = term;
        for (int j = i + 1; j <= x; ++j) {
            sum += (term *= lambda / (double)j);
        }
        return sum;
    }

    public static double barF(double lambda, int x) {
        double term;
        double LAMBDALIM = 200.0;
        if (lambda < 0.0) {
            throw new IllegalArgumentException("lambda < 0");
        }
        if (x <= 0) {
            return 1.0;
        }
        if (lambda >= 100.0 ? (double)x >= 10.0 * lambda : (double)x >= 100.0 + 100.0 * Math.max(1.0, lambda)) {
            return 0.0;
        }
        if (lambda > 200.0) {
            return GammaDist.cdf(x, 15, lambda);
        }
        if ((double)x <= lambda) {
            return 1.0 - PoissonDist.cdf(lambda, x - 1);
        }
        int IMAX = 20;
        double sum = term = PoissonDist.prob(lambda, x);
        for (int i = x + 1; term > EPSILON || i <= x + 20; ++i) {
            sum += (term *= lambda / (double)i);
        }
        return sum;
    }

    public static int inverseF(double lambda, double u) {
        double LAMBDALIM = 700.0;
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u is not in range [0,1]");
        }
        if (lambda < 0.0) {
            throw new IllegalArgumentException("lambda < 0");
        }
        if (u >= 1.0) {
            return Integer.MAX_VALUE;
        }
        if (u <= 0.0) {
            return 0;
        }
        int i = 0;
        if (lambda < 700.0) {
            double sumprev = -1.0;
            u *= Math.exp(lambda);
            double term = 1.0;
            for (double sum = 1.0; sum < u && sum > sumprev; sum += (term *= lambda / (double)(++i))) {
                sumprev = sum;
            }
        } else {
            double term = PoissonDist.prob(lambda, (int)lambda);
            if (u <= 0.5) {
                for (i = (int)lambda; term > EPSILON && i > 0; term *= (double)i / lambda, --i) {
                }
                for (double sum = term; sum < u; sum += (term *= lambda / (double)(++i))) {
                }
            } else {
                for (double sum = PoissonDist.cdf(lambda, (int)lambda); term > EPSILON && sum < u; sum += (term *= lambda / (double)(++i))) {
                }
            }
        }
        return i;
    }

    public static double[] getMLE(int[] x, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double[] parameters = new double[1];
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            sum += (double)x[i];
        }
        parameters[0] = sum / (double)n;
        return parameters;
    }

    public static PoissonDist getInstanceFromMLE(int[] x, int n) {
        double[] parameters = PoissonDist.getMLE(x, n);
        return new PoissonDist(parameters[0]);
    }

    public static double getMean(double lambda) {
        if (lambda < 0.0) {
            throw new IllegalArgumentException("lambda < 0");
        }
        return lambda;
    }

    public static double getVariance(double lambda) {
        if (lambda < 0.0) {
            throw new IllegalArgumentException("lambda < 0");
        }
        return lambda;
    }

    public static double getStandardDeviation(double lambda) {
        if (lambda < 0.0) {
            throw new IllegalArgumentException("lambda < 0");
        }
        return Math.sqrt(lambda);
    }

    public double getLambda() {
        return this.lambda;
    }

    public void setLambda(double lambda) {
        int imax;
        int imin;
        this.supportA = 0;
        if (lambda < 0.0) {
            throw new IllegalArgumentException("lambda < 0");
        }
        this.lambda = lambda;
        if (lambda > MAXLAMBDA) {
            this.pdf = null;
            this.cdf = null;
            return;
        }
        int Nmax = (int)(lambda + 16.0 * (2.0 + Math.sqrt(lambda)));
        double[] P = new double[1 + Nmax];
        double[] F = new double[1 + Nmax];
        int mid = (int)lambda;
        double epsilon = EPSILON * 0.01 / PoissonDist.prob(lambda, mid);
        P[mid] = 1.0;
        double sum = 1.0;
        int i = mid;
        while (i > 0 && P[i] > epsilon) {
            P[i - 1] = P[i] * (double)i / lambda;
            sum += P[--i];
        }
        this.xmin = imin = i;
        i = mid;
        while (P[i] > epsilon) {
            P[i + 1] = P[i] * lambda / (double)(i + 1);
            sum += P[++i];
            if (i < Nmax - 1) continue;
            double[] nT = new double[1 + (Nmax *= 2)];
            System.arraycopy(P, 0, nT, 0, P.length);
            P = nT;
            nT = new double[1 + Nmax];
            System.arraycopy(F, 0, nT, 0, F.length);
            F = nT;
        }
        this.xmax = imax = i;
        i = imin;
        while (i <= imax) {
            int n = i++;
            P[n] = P[n] / sum;
        }
        F[imin] = P[imin];
        i = imin;
        while (i < imax && F[i] < 0.5) {
            F[++i] = P[i] + F[i - 1];
        }
        this.xmed = i;
        F[imax] = P[imax];
        i = imax - 1;
        do {
            F[i] = P[i] + F[i + 1];
        } while (--i > this.xmed);
        for (i = imin; i < this.xmed && F[i] < EPSILON; ++i) {
        }
        this.xmin = imin = i;
        for (i = imax; i > this.xmed && F[i] < EPSILON; --i) {
        }
        this.xmax = imax = i;
        this.pdf = new double[imax + 1 - imin];
        this.cdf = new double[imax + 1 - imin];
        System.arraycopy(P, imin, this.pdf, 0, imax - imin + 1);
        System.arraycopy(F, imin, this.cdf, 0, imax - imin + 1);
    }

    @Override
    public double[] getParams() {
        double[] retour = new double[]{this.lambda};
        return retour;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": lambda = " + this.lambda;
    }
}

