/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Formatter;
import java.util.Locale;
import umontreal.iro.lecuyer.probdist.DiscreteDistribution;
import umontreal.iro.lecuyer.util.Misc;
import umontreal.iro.lecuyer.util.PrintfFormat;

public class EmpiricalDist
extends DiscreteDistribution {
    private double[] sortedObs;
    private int n = 0;
    private double sampleMean;
    private double sampleVariance;
    private double sampleStandardDeviation;

    public EmpiricalDist(double[] obs) {
        if (obs.length <= 1) {
            throw new IllegalArgumentException("Two or more observations are needed");
        }
        this.n = obs.length;
        this.sortedObs = new double[this.n];
        System.arraycopy(obs, 0, this.sortedObs, 0, this.n);
        this.init();
    }

    public EmpiricalDist(Reader in) throws IOException {
        String li;
        BufferedReader inb = new BufferedReader(in);
        double[] data = new double[5];
        while ((li = inb.readLine()) != null) {
            int index;
            li = li.trim();
            for (index = 0; index < li.length() && (li.charAt(index) == '+' || li.charAt(index) == '-' || li.charAt(index) == 'e' || li.charAt(index) == 'E' || li.charAt(index) == '.' || Character.isDigit(li.charAt(index))); ++index) {
            }
            if ((li = li.substring(0, index)).equals("")) continue;
            try {
                data[this.n++] = Double.parseDouble(li);
                if (this.n < data.length) continue;
                double[] newData = new double[2 * this.n];
                System.arraycopy(data, 0, newData, 0, data.length);
                data = newData;
            }
            catch (NumberFormatException nfe) {}
        }
        this.sortedObs = new double[this.n];
        System.arraycopy(data, 0, this.sortedObs, 0, this.n);
        this.init();
    }

    @Override
    public double prob(int i) {
        if (i >= 0 && i < this.n) {
            return 1.0 / (double)this.n;
        }
        throw new IllegalStateException();
    }

    @Override
    public double cdf(double x) {
        if (x < this.sortedObs[0]) {
            return 0.0;
        }
        if (x >= this.sortedObs[this.n - 1]) {
            return 1.0;
        }
        for (int i = 0; i < this.n - 1; ++i) {
            if (!(x >= this.sortedObs[i]) || !(x < this.sortedObs[i + 1])) continue;
            return (double)(i + 1) / (double)this.n;
        }
        throw new IllegalStateException();
    }

    @Override
    public double barF(double x) {
        if (x <= this.sortedObs[0]) {
            return 1.0;
        }
        if (x > this.sortedObs[this.n - 1]) {
            return 0.0;
        }
        for (int i = 0; i < this.n - 1; ++i) {
            if (!(x > this.sortedObs[i]) || !(x <= this.sortedObs[i + 1])) continue;
            return ((double)this.n - 1.0 - (double)i) / (double)this.n;
        }
        throw new IllegalStateException();
    }

    @Override
    public double inverseF(double u) {
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u is not in [0,1]");
        }
        if (u == 1.0) {
            return this.sortedObs[this.n - 1];
        }
        int i = (int)Math.floor((double)this.n * u);
        return this.sortedObs[i];
    }

    private void init() {
        int i;
        double sum = 0.0;
        for (i = 0; i < this.sortedObs.length; ++i) {
            sum += this.sortedObs[i];
        }
        this.sampleMean = sum / (double)this.n;
        sum = 0.0;
        for (i = 0; i < this.n; ++i) {
            double coeff = this.sortedObs[i] - this.sampleMean;
            sum += coeff * coeff;
        }
        this.sampleVariance = sum / (double)(this.n - 1);
        this.sampleStandardDeviation = Math.sqrt(this.sampleVariance);
        this.supportA = this.sortedObs[0];
        this.supportB = this.sortedObs[this.n - 1];
    }

    @Override
    public double getMean() {
        return this.sampleMean;
    }

    @Override
    public double getVariance() {
        return this.sampleVariance;
    }

    @Override
    public double getStandardDeviation() {
        return this.sampleStandardDeviation;
    }

    public double getMedian() {
        if (this.n % 2 == 0) {
            return (this.obs[this.n / 2 - 1] + this.obs[this.n / 2]) / 2.0;
        }
        return this.obs[(this.n - 1) / 2];
    }

    public static double getMedian(double[] obs, int n) {
        if (n % 2 == 0) {
            return (Misc.quickSelect(obs, n, n / 2 - 1) + Misc.quickSelect(obs, n, n / 2)) / 2.0;
        }
        return Misc.quickSelect(obs, n, (n - 1) / 2);
    }

    public int getN() {
        return this.n;
    }

    public double getObs(int i) {
        return this.sortedObs[i];
    }

    public double getSampleMean() {
        return this.sampleMean;
    }

    public double getSampleVariance() {
        return this.sampleVariance;
    }

    public double getSampleStandardDeviation() {
        return this.sampleStandardDeviation;
    }

    public double getInterQuartileRange() {
        int j = this.n / 2;
        double lowerqrt = 0.0;
        double upperqrt = 0.0;
        if (j % 2 == 1) {
            lowerqrt = this.sortedObs[(j + 1) / 2 - 1];
            upperqrt = this.sortedObs[this.n - (j + 1) / 2];
        } else {
            lowerqrt = 0.5 * (this.sortedObs[j / 2 - 1] + this.sortedObs[j / 2 + 1 - 1]);
            upperqrt = 0.5 * (this.sortedObs[this.n - j / 2] + this.sortedObs[this.n - j / 2 - 1]);
        }
        double h = upperqrt - lowerqrt;
        if (h < 0.0) {
            throw new IllegalStateException("Observations MUST be sorted");
        }
        return h;
    }

    @Override
    public double[] getParams() {
        double[] retour = new double[this.n];
        System.arraycopy(this.sortedObs, 0, retour, 0, this.n);
        return retour;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb, Locale.US);
        formatter.format(this.getClass().getSimpleName() + PrintfFormat.NEWLINE, new Object[0]);
        for (int i = 0; i < this.n; ++i) {
            formatter.format("%f%n", this.sortedObs[i]);
        }
        return sb.toString();
    }
}

