/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

import cern.colt.list.IntArrayList;
import umontreal.iro.lecuyer.hups.CycleBasedPointSetBase2;
import umontreal.iro.lecuyer.hups.F2wStructure;
import umontreal.iro.lecuyer.rng.MRG32k3a;
import umontreal.iro.lecuyer.util.PrintfFormat;

public class F2wCycleBasedPolyLCG
extends CycleBasedPointSetBase2 {
    private F2wStructure param;

    public F2wCycleBasedPolyLCG(int w, int r, int modQ, int step, int nbcoeff, int[] coeff, int[] nocoeff) {
        this.param = new F2wStructure(w, r, modQ, step, nbcoeff, coeff, nocoeff);
        this.numBits = this.param.numBits;
        this.normFactor = this.param.normFactor;
        this.EpsilonHalf = this.param.EpsilonHalf;
        this.fillCyclesPolyLCG();
    }

    public F2wCycleBasedPolyLCG(String filename, int no) {
        this.param = new F2wStructure(filename, no);
        this.numBits = this.param.numBits;
        this.normFactor = this.param.normFactor;
        this.fillCyclesPolyLCG();
    }

    @Override
    public String toString() {
        String s = "F2wCycleBasedPolyLCG:" + PrintfFormat.NEWLINE;
        return s + this.param.toString();
    }

    private void fillCyclesPolyLCG() {
        int i;
        int n = 1 << this.param.getLog2N();
        int mask1 = (1 << 31 - this.param.r * this.param.w) - 1;
        int mask2 = ~mask1;
        MRG32k3a random = new MRG32k3a();
        boolean[] stateVisited = new boolean[n];
        for (i = 0; i < n; ++i) {
            stateVisited[i] = false;
        }
        int startState = 0;
        this.numPoints = 0;
        while (startState < n) {
            stateVisited[startState] = true;
            IntArrayList c = new IntArrayList();
            this.param.state = startState << this.param.S;
            c.add(this.param.state);
            this.param.output = this.param.F2wPolyLCG();
            while (this.param.state != startState << this.param.S) {
                stateVisited[this.param.state >> this.param.S] = true;
                c.add(this.param.state);
                this.param.output = this.param.F2wPolyLCG();
            }
            this.addCycle(c);
            for (i = startState + 1; i < n && stateVisited[i]; ++i) {
            }
            startState = i;
        }
    }
}

