/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.functions;

import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.functions.MathFunctionUtil;
import umontreal.iro.lecuyer.functions.MathFunctionWithDerivative;
import umontreal.iro.lecuyer.functions.MathFunctionWithFirstDerivative;
import umontreal.iro.lecuyer.functions.MathFunctionWithIntegral;

public class ShiftedMathFunction
implements MathFunction,
MathFunctionWithFirstDerivative,
MathFunctionWithDerivative,
MathFunctionWithIntegral {
    MathFunction func;
    double delta;

    public ShiftedMathFunction(MathFunction func, double delta) {
        if (func == null) {
            throw new NullPointerException();
        }
        this.func = func;
        this.delta = delta;
    }

    public MathFunction getFunction() {
        return this.func;
    }

    public double getDelta() {
        return this.delta;
    }

    @Override
    public double evaluate(double x) {
        return this.func.evaluate(x) - this.delta;
    }

    @Override
    public double derivative(double x) {
        return MathFunctionUtil.derivative(this.func, x);
    }

    @Override
    public double derivative(double x, int n) {
        return MathFunctionUtil.derivative(this.func, x, n);
    }

    @Override
    public double integral(double a, double b) {
        return MathFunctionUtil.integral(this.func, a, b) - (b - a) * this.getDelta();
    }
}

