/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.functions;

import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.functions.MathFunctionUtil;
import umontreal.iro.lecuyer.functions.MathFunctionWithFirstDerivative;

public class PowerMathFunction
implements MathFunction,
MathFunctionWithFirstDerivative {
    private MathFunction func;
    private double a;
    private double b;
    private double power;

    public PowerMathFunction(MathFunction func, double power) {
        this(func, 1.0, 0.0, power);
    }

    public PowerMathFunction(MathFunction func, double a, double b, double power) {
        if (func == null) {
            throw new NullPointerException();
        }
        this.func = func;
        this.a = a;
        this.b = b;
        this.power = power;
    }

    public MathFunction getFunction() {
        return this.func;
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public double getPower() {
        return this.power;
    }

    @Override
    public double derivative(double x) {
        double fder = MathFunctionUtil.derivative(this.func, x);
        return this.getA() * this.getPower() * Math.pow(this.getA() * this.func.evaluate(x) + this.getB(), this.getPower() - 1.0) * fder;
    }

    @Override
    public double evaluate(double x) {
        double v = this.func.evaluate(x);
        return Math.pow(this.a * v + this.b, this.power);
    }
}

