/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.charts;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;
import org.jfree.util.ShapeUtilities;

public class EmpiricalRenderer
extends XYLineAndShapeRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable {
    public EmpiricalRenderer() {
        this(null, null);
    }

    public EmpiricalRenderer(XYToolTipGenerator toolTipGenerator, XYURLGenerator urlGenerator) {
        this.setBaseToolTipGenerator(toolTipGenerator);
        this.setURLGenerator(urlGenerator);
        this.setShapesFilled(true);
        this.setShapesVisible(true);
    }

    @Override
    public void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        EntityCollection entities;
        if (!this.getItemVisible(series, item)) {
            return;
        }
        PlotOrientation orientation = plot.getOrientation();
        Paint seriesPaint = this.getItemPaint(series, item);
        Stroke seriesStroke = this.getItemStroke(series, item);
        g2.setPaint(seriesPaint);
        g2.setStroke(seriesStroke);
        double x0 = dataset.getXValue(series, item);
        double y0 = dataset.getYValue(series, item);
        if (Double.isNaN(y0)) {
            return;
        }
        RectangleEdge xAxisLocation = plot.getDomainAxisEdge();
        RectangleEdge yAxisLocation = plot.getRangeAxisEdge();
        double transX0 = domainAxis.valueToJava2D(x0, dataArea, xAxisLocation);
        double transY0 = rangeAxis.valueToJava2D(y0, dataArea, yAxisLocation);
        double x1 = 0.0;
        double y1 = 0.0;
        if (item < dataset.getItemCount(series) - 1) {
            x1 = dataset.getXValue(series, item + 1);
            y1 = dataset.getYValue(series, item + 1);
        } else {
            x1 = dataArea.getMaxX();
            y1 = dataArea.getMaxY();
        }
        boolean useFillPaint = this.getUseFillPaint();
        boolean drawOutlines = this.getDrawOutlines();
        if (!Double.isNaN(y0)) {
            double transY1;
            double transX1;
            if (item < dataset.getItemCount(series) - 1) {
                transX1 = domainAxis.valueToJava2D(x1, dataArea, xAxisLocation);
                transY1 = rangeAxis.valueToJava2D(y1, dataArea, yAxisLocation);
            } else {
                transX1 = x1;
                transY1 = y1;
            }
            Line2D line = state.workingLine;
            if (orientation == PlotOrientation.HORIZONTAL) {
                line.setLine(transY0, transX0, transY0, transX1);
                g2.draw(line);
            } else if (orientation == PlotOrientation.VERTICAL) {
                line.setLine(transX0, transY0, transX1, transY0);
                g2.draw(line);
            }
        }
        if (this.getItemShapeVisible(series, item)) {
            Shape shape = this.getItemShape(series, item);
            if (orientation == PlotOrientation.HORIZONTAL) {
                shape = ShapeUtilities.createTranslatedShape((Shape)shape, (double)transY0, (double)transX0);
            } else if (orientation == PlotOrientation.VERTICAL) {
                shape = ShapeUtilities.createTranslatedShape((Shape)shape, (double)transX0, (double)transY0);
            }
            if (shape.intersects(dataArea)) {
                if (this.getItemShapeFilled(series, item)) {
                    if (useFillPaint) {
                        g2.setPaint(this.getItemFillPaint(series, item));
                    } else {
                        g2.setPaint(this.getItemPaint(series, item));
                    }
                    g2.fill(shape);
                }
                if (drawOutlines) {
                    if (this.getUseOutlinePaint()) {
                        g2.setPaint(this.getItemOutlinePaint(series, item));
                    } else {
                        g2.setPaint(this.getItemPaint(series, item));
                    }
                    g2.setStroke(this.getItemOutlineStroke(series, item));
                    g2.draw(shape);
                }
            }
        }
        if (this.isItemLabelVisible(series, item)) {
            double xx = transX0;
            double yy = transY0;
            if (orientation == PlotOrientation.HORIZONTAL) {
                xx = transY0;
                yy = transX0;
            }
            this.drawItemLabel(g2, orientation, dataset, series, item, xx, yy, y0 < 0.0);
        }
        int domainAxisIndex = plot.getDomainAxisIndex(domainAxis);
        int rangeAxisIndex = plot.getRangeAxisIndex(rangeAxis);
        this.updateCrosshairValues(crosshairState, x0, y0, domainAxisIndex, rangeAxisIndex, transX0, transY0, orientation);
        if (state.getInfo() != null && (entities = state.getEntityCollection()) != null) {
            Rectangle2D.Double shape;
            int r = this.getDefaultEntityRadius();
            Rectangle2D.Double double_ = shape = orientation != PlotOrientation.VERTICAL ? new Rectangle2D.Double(transY0 - (double)r, transX0 - (double)r, 2 * r, 2 * r) : new Rectangle2D.Double(transX0 - (double)r, transY0 - (double)r, 2 * r, 2 * r);
            if (shape != null) {
                String tip = null;
                XYToolTipGenerator generator = this.getToolTipGenerator(series, item);
                if (generator != null) {
                    tip = generator.generateToolTip(dataset, series, item);
                }
                String url = null;
                if (this.getURLGenerator() != null) {
                    url = this.getURLGenerator().generateURL(dataset, series, item);
                }
                XYItemEntity entity = new XYItemEntity(shape, dataset, series, item, tip, url);
                entities.add(entity);
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

