/*
 * Decompiled with CFR 0.152.
 */
import java.util.LinkedList;
import umontreal.iro.lecuyer.randvar.ExponentialGen;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.rng.MRG32k3a;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.simevents.Accumulate;
import umontreal.iro.lecuyer.simevents.Event;
import umontreal.iro.lecuyer.simevents.Sim;
import umontreal.iro.lecuyer.stat.Tally;

public class QueueEv {
    RandomVariateGen genArr;
    RandomVariateGen genServ;
    LinkedList<Customer> waitList = new LinkedList();
    LinkedList<Customer> servList = new LinkedList();
    Tally custWaits = new Tally("Waiting times");
    Accumulate totWait = new Accumulate("Size of queue");

    public QueueEv(double lambda, double mu) {
        this.genArr = new ExponentialGen((RandomStream)new MRG32k3a(), lambda);
        this.genServ = new ExponentialGen((RandomStream)new MRG32k3a(), mu);
    }

    public void simulateOneRun(double timeHorizon) {
        Sim.init();
        new EndOfSim().schedule(timeHorizon);
        new Arrival().schedule(this.genArr.nextDouble());
        Sim.start();
    }

    public static void main(String[] args) {
        QueueEv queue = new QueueEv(1.0, 2.0);
        queue.simulateOneRun(1000.0);
        System.out.println(queue.custWaits.report());
        System.out.println(queue.totWait.report());
    }

    class EndOfSim
    extends Event {
        EndOfSim() {
        }

        @Override
        public void actions() {
            Sim.stop();
        }
    }

    class Departure
    extends Event {
        Departure() {
        }

        @Override
        public void actions() {
            QueueEv.this.servList.removeFirst();
            if (QueueEv.this.waitList.size() > 0) {
                Customer cust = QueueEv.this.waitList.removeFirst();
                QueueEv.this.totWait.update(QueueEv.this.waitList.size());
                QueueEv.this.custWaits.add(Sim.time() - cust.arrivTime);
                QueueEv.this.servList.addLast(cust);
                new Departure().schedule(cust.servTime);
            }
        }
    }

    class Arrival
    extends Event {
        Arrival() {
        }

        @Override
        public void actions() {
            new Arrival().schedule(QueueEv.this.genArr.nextDouble());
            Customer cust = new Customer();
            cust.arrivTime = Sim.time();
            cust.servTime = QueueEv.this.genServ.nextDouble();
            if (QueueEv.this.servList.size() > 0) {
                QueueEv.this.waitList.addLast(cust);
                QueueEv.this.totWait.update(QueueEv.this.waitList.size());
            } else {
                QueueEv.this.custWaits.add(0.0);
                QueueEv.this.servList.addLast(cust);
                new Departure().schedule(cust.servTime);
            }
        }
    }

    class Customer {
        double arrivTime;
        double servTime;

        Customer() {
        }
    }
}

