/*
 * Decompiled with CFR 0.152.
 */
package javanpst.utils;

public class ContinuedFraction {
    private static final double EPSILON = 1.0E-8;
    private static final int ITERATIONS = 1000;
    private double a;

    public ContinuedFraction(double value) {
        this.a = value;
    }

    private double getA(int n, double x) {
        return 2.0 * (double)n + 1.0 - this.a + x;
    }

    private double getB(int n, double x) {
        return (double)n * (this.a - (double)n);
    }

    public double evaluate(double x) {
        double p0 = 1.0;
        double p1 = this.getA(0, x);
        double q0 = 0.0;
        double q1 = 1.0;
        double c = p1 / q1;
        int n = 0;
        double relativeError = Double.MAX_VALUE;
        while (n < 1000 && relativeError > 1.0E-8) {
            double a = this.getA(++n, x);
            double b = this.getB(n, x);
            double p2 = a * p1 + b * p0;
            double q2 = a * q1 + b * q0;
            if (Double.isInfinite(p2) || Double.isInfinite(q2)) {
                if (a != 0.0) {
                    p2 = p1 + b / a * p0;
                    q2 = q1 + b / a * q0;
                } else if (b != 0.0) {
                    p2 = a / b * p1 + p0;
                    q2 = a / b * q1 + q0;
                } else {
                    return -1.0;
                }
            }
            double r = p2 / q2;
            relativeError = Math.abs(r / c - 1.0);
            c = p2 / q2;
            p0 = p1;
            p1 = p2;
            q0 = q1;
            q1 = q2;
        }
        return c;
    }
}

