/*
 * Decompiled with CFR 0.152.
 */
package javanpst.tests.twoSample.wald_WolfowitzTest;

import java.util.Arrays;
import javanpst.data.structures.dataTable.DataTable;
import javanpst.data.structures.sequence.StringSequence;
import javanpst.distributions.tests.TotalNumberOfRunsDistribution;
import javanpst.tests.StatisticalTest;

public class Wald_WolfowitzTest
extends StatisticalTest {
    private TotalNumberOfRunsDistribution distribution;
    private DataTable data;
    private double[] sample1;
    private double[] sample2;
    private StringSequence sequence;
    private int R;
    private double exactPValue;
    private double asymptoticPValue;

    public Wald_WolfowitzTest() {
        this.distribution = TotalNumberOfRunsDistribution.getInstance();
        this.setReportFormat();
        this.clearData();
    }

    @Override
    public void clearData() {
        this.data = new DataTable();
        this.sequence = new StringSequence();
        this.sample1 = null;
        this.sample2 = null;
        this.performed = false;
        this.dataReady = false;
        this.R = 0;
        this.exactPValue = -1.0;
        this.asymptoticPValue = -1.0;
    }

    public Wald_WolfowitzTest(DataTable newData) {
        boolean last = false;
        this.distribution = TotalNumberOfRunsDistribution.getInstance();
        this.setReportFormat();
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() != 2) {
            System.out.println("Wald-Wolfowitz test only can be employed with two samples");
            this.clearData();
            return;
        }
        int nulls = this.data.getColumnNulls(0);
        this.sample1 = new double[this.data.getRows() - nulls];
        nulls = this.data.getColumnNulls(1);
        this.sample2 = new double[this.data.getRows() - nulls];
        int counter1 = 0;
        int counter2 = 0;
        for (int i = 0; i < this.data.getRows(); ++i) {
            double value = this.data.get(i, 0);
            if (value != Double.MIN_VALUE) {
                this.sample1[counter1] = value;
                ++counter1;
            }
            if ((value = this.data.get(i, 1)) == Double.MIN_VALUE) continue;
            this.sample2[counter2] = value;
            ++counter2;
        }
        int pointer1 = 0;
        int pointer2 = 0;
        Arrays.sort(this.sample1);
        Arrays.sort(this.sample2);
        this.sequence = new StringSequence();
        while (pointer1 < this.data.getRows() && pointer2 < this.data.getRows()) {
            double value2;
            double value1 = this.data.get(pointer1, 0);
            if (value1 < (value2 = this.data.get(pointer2, 1))) {
                this.sequence.append("X");
                ++pointer1;
                last = true;
            }
            if (value1 > value2) {
                this.sequence.append("Y");
                ++pointer2;
                last = false;
            }
            if (value1 != value2) continue;
            if (last) {
                this.sequence.append("Y");
                ++pointer2;
                last = false;
                continue;
            }
            this.sequence.append("X");
            ++pointer1;
            last = true;
        }
        while (pointer1 < this.data.getRows()) {
            this.sequence.append("X");
            ++pointer1;
        }
        while (pointer2 < this.data.getRows()) {
            this.sequence.append("Y");
            ++pointer2;
        }
        this.dataReady = true;
        this.performed = false;
    }

    public void setData(DataTable newData) {
        boolean last = false;
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() != 2) {
            System.out.println("Wald-Wolfowitz test only can be employed with two samples");
            this.clearData();
            return;
        }
        int nulls = this.data.getColumnNulls(0);
        this.sample1 = new double[this.data.getRows() - nulls];
        nulls = this.data.getColumnNulls(1);
        this.sample2 = new double[this.data.getRows() - nulls];
        int counter1 = 0;
        int counter2 = 0;
        for (int i = 0; i < this.data.getRows(); ++i) {
            double value = this.data.get(i, 0);
            if (value != Double.MIN_VALUE) {
                this.sample1[counter1] = value;
                ++counter1;
            }
            if ((value = this.data.get(i, 1)) == Double.MIN_VALUE) continue;
            this.sample2[counter2] = value;
            ++counter2;
        }
        int pointer1 = 0;
        int pointer2 = 0;
        Arrays.sort(this.sample1);
        Arrays.sort(this.sample2);
        this.sequence = new StringSequence();
        while (pointer1 < this.data.getRows() && pointer2 < this.data.getRows()) {
            double value2;
            double value1 = this.data.get(pointer1, 0);
            if (value1 < (value2 = this.data.get(pointer2, 1))) {
                this.sequence.append("X");
                ++pointer1;
                last = true;
            }
            if (value1 > value2) {
                this.sequence.append("Y");
                ++pointer2;
                last = false;
            }
            if (value1 != value2) continue;
            if (last) {
                this.sequence.append("Y");
                ++pointer2;
                last = false;
                continue;
            }
            this.sequence.append("X");
            ++pointer1;
            last = true;
        }
        while (pointer1 < this.data.getRows()) {
            this.sequence.append("X");
            ++pointer1;
        }
        while (pointer2 < this.data.getRows()) {
            this.sequence.append("Y");
            ++pointer2;
        }
        this.dataReady = true;
        this.performed = false;
    }

    @Override
    public void doTest() {
        if (!this.dataReady) {
            System.out.println("Data is not ready");
            return;
        }
        this.R = 1;
        String c = this.sequence.get(0);
        for (int i = 1; i < this.sequence.size(); ++i) {
            if (this.sequence.get(i).equals(c)) continue;
            ++this.R;
            c = this.sequence.get(i);
        }
        this.exactPValue = this.distribution.computeLeftTailProbability(this.sample1.length, this.sample2.length, this.R);
        this.asymptoticPValue = this.distribution.computeAsymptoticLeftTailProbability(this.sample1.length, this.sample2.length, this.R);
        this.performed = true;
    }

    public double getR() {
        return this.R;
    }

    public double getExactPValue() {
        return this.exactPValue;
    }

    public double getAsymptoticPValue() {
        return this.asymptoticPValue;
    }

    @Override
    public String printData() {
        String text = "";
        text = text + "\n" + this.data;
        return text;
    }

    @Override
    public String printReport() {
        String report = "";
        if (!this.performed) {
            report = report + "The test has not been performed.\n";
            return report;
        }
        report = report + "\n***************************************\n";
        report = report + "Wald-Wolfowitz test\n";
        report = report + "***************************************\n\n";
        report = report + "R statistic: " + this.nf6.format(this.R) + "\n\n";
        if (this.exactPValue != -1.0) {
            report = report + "Exact P-Value (Left tail, Y > X): " + this.nf6.format(this.exactPValue) + "\n";
        }
        report = report + "Asymptotic P-Value: " + this.nf6.format(this.asymptoticPValue) + "\n";
        return report;
    }
}

