/*
 * Decompiled with CFR 0.152.
 */
package javanpst.tests.randomness.runsUpDownTest;

import javanpst.data.structures.sequence.NumericSequence;
import javanpst.distributions.tests.RunsUpDownDistribution;
import javanpst.tests.StatisticalTest;

public class RunsUpDownTest
extends StatisticalTest {
    private RunsUpDownDistribution distribution;
    private NumericSequence sequence;
    private int runs;
    private double exactLeftTail;
    private double exactRightTail;
    private double exactDoubleTail;
    private double asymptoticLeftTail;
    private double asymptoticRightTail;
    private double asymptoticDoubleTail;

    public RunsUpDownTest() {
        this.distribution = RunsUpDownDistribution.getInstance();
        this.setReportFormat();
        this.clearData();
    }

    @Override
    public void clearData() {
        this.sequence = new NumericSequence();
        this.performed = false;
        this.dataReady = false;
        this.runs = 0;
        this.exactLeftTail = -1.0;
        this.exactRightTail = -1.0;
        this.exactDoubleTail = -1.0;
        this.asymptoticLeftTail = -1.0;
        this.asymptoticRightTail = -1.0;
        this.asymptoticDoubleTail = -1.0;
    }

    public RunsUpDownTest(NumericSequence newSequence) {
        this.setReportFormat();
        this.distribution = RunsUpDownDistribution.getInstance();
        this.sequence = new NumericSequence(newSequence);
        this.dataReady = true;
        this.performed = false;
    }

    public void setData(NumericSequence newSequence) {
        this.sequence = new NumericSequence(newSequence);
        this.dataReady = true;
        this.performed = false;
    }

    @Override
    public void doTest() {
        if (!this.dataReady) {
            System.out.println("Data is not ready");
            return;
        }
        this.computeRuns();
        this.exactLeftTail = this.distribution.computeExactProbability(this.sequence.size(), this.runs, true);
        this.exactRightTail = this.distribution.computeExactProbability(this.sequence.size(), this.runs, false);
        this.exactDoubleTail = Math.min(Math.min(this.exactLeftTail, this.exactRightTail) * 2.0, 1.0);
        this.asymptoticLeftTail = this.distribution.computeAsymptoticLeftTailProbability(this.sequence.size(), this.runs);
        this.asymptoticRightTail = this.distribution.computeAsymptoticRightTailProbability(this.sequence.size(), this.runs);
        this.asymptoticDoubleTail = this.distribution.computeAsymptoticDoubleTailProbability(this.sequence.size(), this.runs);
        this.performed = true;
    }

    private void computeRuns() {
        double newN;
        this.runs = 1;
        double lastN = this.sequence.get(0);
        boolean ascending = lastN <= (newN = this.sequence.get(1));
        lastN = newN;
        for (int i = 2; i < this.sequence.size(); ++i) {
            newN = this.sequence.get(i);
            if (ascending) {
                if (lastN > newN) {
                    ++this.runs;
                    ascending = false;
                }
            } else if (lastN < newN) {
                ++this.runs;
                ascending = true;
            }
            lastN = newN;
        }
    }

    public double getRuns() {
        return this.runs;
    }

    public double getExactLeftPValue() {
        return this.exactLeftTail;
    }

    public double getExactRightPValue() {
        return this.exactRightTail;
    }

    public double getExactDoublePValue() {
        return this.exactDoubleTail;
    }

    public double getLeftPValue() {
        return this.asymptoticLeftTail;
    }

    public double getRightPValue() {
        return this.asymptoticRightTail;
    }

    public double getDoublePValue() {
        return this.asymptoticDoubleTail;
    }

    @Override
    public String printData() {
        String text = "";
        text = text + "\n" + this.sequence;
        return text;
    }

    @Override
    public String printReport() {
        String report = "";
        if (!this.performed) {
            report = report + "The test has not been performed.\n";
            return report;
        }
        report = report + "\n*******************\n";
        report = report + "Runs up down test\n";
        report = report + "*******************\n\n";
        report = report + "Number of elements: " + this.sequence.size() + "\n";
        report = report + "Number of runs: " + this.nf6.format(this.runs) + "\n\n";
        report = report + "Exact P-Value (Left tail, Too few runs): " + this.nf6.format(this.exactLeftTail) + "\n";
        report = report + "Exact P-Value (Right tail, Too many runs): " + this.nf6.format(this.exactRightTail) + "\n";
        report = report + "Exact P-Value (Double tail, Non randomness): " + this.nf6.format(this.exactDoubleTail) + "\n\n";
        report = report + "Asymptotic P-Value (Left tail, Too few runs): " + this.nf6.format(this.asymptoticLeftTail) + "\n";
        report = report + "Asymptotic P-Value (Right tail, Too many runs): " + this.nf6.format(this.asymptoticRightTail) + "\n";
        report = report + "Asymptotic P-Value (Double tail, Non randomness): " + this.nf6.format(this.asymptoticDoubleTail) + "\n\n";
        return report;
    }
}

