/*
 * Decompiled with CFR 0.152.
 */
package javanpst.tests.randomness.runsUpDownMedianTest;

import javanpst.data.structures.sequence.NumericSequence;
import javanpst.distributions.tests.TotalNumberOfRunsDistribution;
import javanpst.tests.StatisticalTest;

public class RunsUpDownMedianTest
extends StatisticalTest {
    private TotalNumberOfRunsDistribution distribution = TotalNumberOfRunsDistribution.getInstance();
    private NumericSequence sequence;
    private double median;
    private int n1;
    private int n2;
    private int runs;
    private double exactLeftTail;
    private double exactRightTail;
    private double exactDoubleTail;
    private double asymptoticLeftTail;
    private double asymptoticRightTail;
    private double asymptoticDoubleTail;

    public RunsUpDownMedianTest() {
        this.setReportFormat();
        this.clearData();
    }

    @Override
    public void clearData() {
        this.sequence = new NumericSequence();
        this.performed = false;
        this.dataReady = false;
        this.n1 = 0;
        this.n2 = 0;
        this.runs = 0;
        this.median = 0.0;
        this.exactLeftTail = -1.0;
        this.exactRightTail = -1.0;
        this.exactDoubleTail = -1.0;
        this.asymptoticLeftTail = -1.0;
        this.asymptoticRightTail = -1.0;
        this.asymptoticDoubleTail = -1.0;
    }

    public RunsUpDownMedianTest(NumericSequence newSequence) {
        this.setReportFormat();
        this.sequence = new NumericSequence(newSequence);
        this.dataReady = true;
        this.performed = false;
    }

    public void setData(NumericSequence newSequence) {
        this.sequence = new NumericSequence(newSequence);
        this.dataReady = true;
        this.performed = false;
    }

    @Override
    public void doTest() {
        if (!this.dataReady) {
            System.out.println("Data is not ready");
            return;
        }
        this.countElementsMedian();
        this.computeRuns();
        this.exactLeftTail = this.distribution.computeLeftTailProbability(this.n1, this.n2, this.runs);
        this.exactRightTail = this.distribution.computeRightTailProbability(this.n1, this.n2, this.runs);
        if (this.exactLeftTail == -1.0) {
            this.exactLeftTail = 1.0;
        }
        if (this.exactRightTail == -1.0) {
            this.exactRightTail = 1.0;
        }
        this.exactDoubleTail = Math.min(Math.min(this.exactLeftTail, this.exactRightTail) * 2.0, 1.0);
        this.asymptoticLeftTail = this.distribution.computeAsymptoticLeftTailProbability(this.n1, this.n2, this.runs);
        this.asymptoticRightTail = this.distribution.computeAsymptoticRightTailProbability(this.n1, this.n2, this.runs);
        this.asymptoticDoubleTail = this.distribution.computeAsymptoticDoubleTailProbability(this.n1, this.n2, this.runs);
        this.performed = true;
    }

    private void countElementsMedian() {
        NumericSequence copy = new NumericSequence(this.sequence);
        copy.sort();
        int index = copy.size() / 2;
        this.median = copy.size() % 2 == 1 ? copy.get(index) : (copy.get(index - 1) + copy.get(index)) / 2.0;
        this.n1 = 0;
        this.n2 = 0;
        for (int i = 0; i < this.sequence.size(); ++i) {
            if (this.sequence.get(i) > this.median) {
                ++this.n1;
            }
            if (!(this.sequence.get(i) < this.median)) continue;
            ++this.n2;
        }
    }

    private void computeRuns() {
        int i;
        this.runs = 1;
        for (i = 0; this.sequence.get(i) == this.median && i < this.sequence.size(); ++i) {
        }
        double value = this.sequence.get(i);
        boolean greater = value > this.median;
        while (i < this.sequence.size()) {
            value = this.sequence.get(i);
            if (greater) {
                if (value < this.median) {
                    ++this.runs;
                    greater = false;
                }
            } else if (value > this.median) {
                ++this.runs;
                greater = true;
            }
            ++i;
        }
    }

    public double getMedian() {
        return this.median;
    }

    public double getRuns() {
        return this.runs;
    }

    public double getExactLeftPValue() {
        return this.exactLeftTail;
    }

    public double getExactRightPValue() {
        return this.exactRightTail;
    }

    public double getExactDoublePValue() {
        return this.exactDoubleTail;
    }

    public double getLeftPValue() {
        return this.asymptoticLeftTail;
    }

    public double getRightPValue() {
        return this.asymptoticRightTail;
    }

    public double getDoublePValue() {
        return this.asymptoticDoubleTail;
    }

    @Override
    public String printData() {
        String text = "";
        text = text + "\n" + this.sequence;
        return text;
    }

    @Override
    public String printReport() {
        String report = "";
        if (!this.performed) {
            report = report + "The test has not been performed.\n";
            return report;
        }
        report = report + "\n**********************************\n";
        report = report + "Runs up down (based on median) test\n";
        report = report + "************************************\n\n";
        report = report + "Median of the sequence: " + this.nf6.format(this.median) + "\n";
        report = report + "Number of runs: " + this.nf6.format(this.runs) + "\n\n";
        report = report + "Exact P-Value (Left tail, Too few runs): " + this.nf6.format(this.exactLeftTail) + "\n";
        report = report + "Exact P-Value (Right tail, Too many runs): " + this.nf6.format(this.exactRightTail) + "\n";
        report = report + "Exact P-Value (Double tail, Non randomness): " + this.nf6.format(this.exactDoubleTail) + "\n\n";
        report = report + "Asymptotic P-Value (Left tail, Too few runs): " + this.nf6.format(this.asymptoticLeftTail) + "\n";
        report = report + "Asymptotic P-Value (Right tail, Too many runs): " + this.nf6.format(this.asymptoticRightTail) + "\n";
        report = report + "Asymptotic P-Value (Double tail, Non randomness): " + this.nf6.format(this.asymptoticDoubleTail) + "\n\n";
        return report;
    }
}

