/*
 * Decompiled with CFR 0.152.
 */
package javanpst.tests.multiple.friedmanTest;

import java.util.Arrays;
import javanpst.data.structures.dataTable.DataTable;
import javanpst.distributions.common.continuous.ChiSquareDistribution;
import javanpst.distributions.common.continuous.NormalDistribution;
import javanpst.tests.StatisticalTest;

public class FriedmanTest
extends StatisticalTest {
    private DataTable data;
    private double[][] samples;
    private double[][] ranks;
    private double[] sumRanks;
    private double[] avgRanks;
    private double S;
    private double Q;
    private double tiesWeight;
    private double pValue;
    private double criticalZ90;
    private double criticalZ95;

    public FriedmanTest() {
        this.setReportFormat();
        this.clearData();
    }

    @Override
    public void clearData() {
        this.data = new DataTable();
        this.performed = false;
        this.dataReady = false;
        this.S = 0.0;
        this.Q = 0.0;
        this.samples = null;
        this.ranks = null;
        this.sumRanks = null;
        this.avgRanks = null;
        this.pValue = -1.0;
    }

    public FriedmanTest(DataTable newData) {
        int i;
        this.setReportFormat();
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() < 3) {
            System.out.println("Extended median test only can be employed with more than two samples");
            this.clearData();
            return;
        }
        for (i = 0; i < this.data.getColumns(); ++i) {
            if (this.data.getColumnNulls(i) <= 0) continue;
            System.out.println("No null values allowed in this test.");
            this.clearData();
            return;
        }
        this.samples = new double[this.data.getRows()][this.data.getColumns()];
        this.ranks = new double[this.data.getRows()][this.data.getColumns()];
        this.sumRanks = new double[this.data.getColumns()];
        this.avgRanks = new double[this.sumRanks.length];
        for (i = 0; i < this.data.getRows(); ++i) {
            Arrays.fill(this.ranks[i], -1.0);
            for (int j = 0; j < this.data.getColumns(); ++j) {
                this.samples[i][j] = this.data.get(i, j);
            }
        }
        Arrays.fill(this.sumRanks, 0.0);
        this.dataReady = true;
        this.performed = false;
    }

    public void setData(DataTable newData) {
        int i;
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() < 3) {
            System.out.println("Friedman test only can be employed with more than two samples");
            this.clearData();
            return;
        }
        for (i = 0; i < this.data.getColumns(); ++i) {
            if (this.data.getColumnNulls(i) <= 0) continue;
            System.out.println("No null values allowed in this test.");
            this.clearData();
            return;
        }
        this.samples = new double[this.data.getRows()][this.data.getColumns()];
        this.ranks = new double[this.data.getRows()][this.data.getColumns()];
        this.sumRanks = new double[this.data.getColumns()];
        this.avgRanks = new double[this.sumRanks.length];
        for (i = 0; i < this.data.getRows(); ++i) {
            Arrays.fill(this.ranks[i], -1.0);
            for (int j = 0; j < this.data.getColumns(); ++j) {
                this.samples[i][j] = this.data.get(i, j);
            }
        }
        Arrays.fill(this.sumRanks, 0.0);
        this.dataReady = true;
        this.performed = false;
    }

    @Override
    public void doTest() {
        int i;
        if (!this.dataReady) {
            System.out.println("Data is not ready");
            return;
        }
        this.computeRanks();
        for (i = 0; i < this.data.getRows(); ++i) {
            for (int j = 0; j < this.data.getColumns(); ++j) {
                int n = j;
                this.sumRanks[n] = this.sumRanks[n] + this.ranks[i][j];
            }
        }
        for (i = 0; i < this.sumRanks.length; ++i) {
            this.avgRanks[i] = this.sumRanks[i] / (double)this.data.getRows();
        }
        for (int j = 0; j < this.data.getColumns(); ++j) {
            this.S += this.sumRanks[j] * this.sumRanks[j];
        }
        this.S -= (double)(this.data.getRows() * this.data.getRows() * this.data.getColumns()) * ((double)this.data.getColumns() + 1.0) * ((double)this.data.getColumns() + 1.0) / 4.0;
        this.Q = 12.0 * ((double)this.data.getColumns() - 1.0) * this.S;
        this.Q /= (double)(this.data.getRows() * this.data.getColumns()) * ((double)(this.data.getColumns() * this.data.getColumns()) - 1.0) - this.tiesWeight;
        this.computePValue(this.sumRanks.length - 1);
        this.multipleComparisonsProcedure();
        this.performed = true;
    }

    private void multipleComparisonsProcedure() {
        double critical90 = 1.0 - 0.1 / (double)(this.sumRanks.length * (this.sumRanks.length - 1));
        double critical95 = 1.0 - 0.05 / (double)(this.sumRanks.length * (this.sumRanks.length - 1));
        NormalDistribution normal = new NormalDistribution();
        critical90 = normal.inverseNormalDistribution(critical90);
        critical95 = normal.inverseNormalDistribution(critical95);
        double N = this.data.getColumns();
        double denominator = Math.sqrt(N * (N + 1.0) / 12.0 * (1.0 / (double)this.data.getRows() + 1.0 / (double)this.data.getRows()));
        this.criticalZ90 = critical90 * denominator;
        this.criticalZ95 = critical95 * denominator;
    }

    private void computePValue(int dF) {
        ChiSquareDistribution chi = new ChiSquareDistribution();
        chi.setDegree(dF);
        this.pValue = chi.computeCumulativeProbability(this.Q);
    }

    private void computeRanks() {
        this.tiesWeight = 0.0;
        for (int i = 0; i < this.data.getRows(); ++i) {
            int count;
            double rank = 1.0;
            do {
                double newRank;
                int j;
                double min = Double.MAX_VALUE;
                count = 0;
                for (j = 0; j < this.data.getColumns(); ++j) {
                    if (this.ranks[i][j] == -1.0 && this.samples[i][j] == min) {
                        ++count;
                    }
                    if (this.ranks[i][j] != -1.0 || !(this.samples[i][j] < min)) continue;
                    min = this.samples[i][j];
                    count = 1;
                }
                if (count == 1) {
                    newRank = rank;
                } else {
                    this.tiesWeight += (double)count * ((double)(count * count) - 1.0);
                    newRank = 0.0;
                    for (int k = 0; k < count; ++k) {
                        newRank += rank + (double)k;
                    }
                    newRank /= (double)count;
                }
                for (j = 0; j < this.data.getColumns(); ++j) {
                    if (this.samples[i][j] != min) continue;
                    this.ranks[i][j] = newRank;
                }
            } while ((rank += (double)count) <= (double)this.data.getColumns());
        }
    }

    public double getS() {
        return this.S;
    }

    public double getQ() {
        return this.Q;
    }

    public double getPValue() {
        return this.pValue;
    }

    public double getAvgRanks(int pop) {
        if (pop - 1 > -1 && pop - 1 < this.avgRanks.length) {
            return this.avgRanks[pop - 1];
        }
        return -1.0;
    }

    @Override
    public String printData() {
        String text = "";
        text = text + "\n" + this.data;
        return text;
    }

    @Override
    public String printReport() {
        int j;
        String report = "";
        if (!this.performed) {
            report = report + "The test has not been performed.\n";
            return report;
        }
        report = report + "\n******************\n";
        report = report + "Friedman test\n";
        report = report + "******************\n\n";
        report = report + "Sum of ranks:\n";
        for (j = 0; j < this.sumRanks.length; ++j) {
            report = report + "S" + (j + 1) + "\t";
        }
        report = report + "\n";
        for (j = 0; j < this.sumRanks.length; ++j) {
            report = report + this.nf6.format(this.sumRanks[j]) + "\t";
        }
        report = report + "\n";
        report = report + "\n";
        report = report + "Average ranks:\n";
        for (j = 0; j < this.avgRanks.length; ++j) {
            report = report + "S" + (j + 1) + "\t";
        }
        report = report + "\n";
        for (j = 0; j < this.avgRanks.length; ++j) {
            report = report + this.nf6.format(this.avgRanks[j]) + "\t";
        }
        report = report + "\n";
        report = report + "\n";
        report = report + "S statistic: " + this.nf6.format(this.S) + "\n";
        report = report + "Q statistic: " + this.nf6.format(this.Q) + "\n\n";
        report = report + "P-Value computed :" + this.nf6.format(this.pValue) + "\n\n";
        return report;
    }

    public String printMultipleComparisonsProcedureReport() {
        String report = "";
        if (!this.performed) {
            report = report + "The test has not been performed.\n";
            return report;
        }
        report = report + "\n***************************************\n";
        report = report + "Multiple comparisons procedure (Friedman test)\n";
        report = report + "***************************************\n\n";
        report = report + "Critical values: Alpha=0.90: " + this.criticalZ90 + " Alpha=0.95: " + this.criticalZ95 + "\n\n";
        report = report + "Individual comparisons:\n\n";
        for (int first = 0; first < this.data.getColumns() - 1; ++first) {
            for (int second = first + 1; second < this.data.getColumns(); ++second) {
                double Z = Math.abs(this.avgRanks[first] - this.avgRanks[second]);
                report = report + (first + 1) + " vs " + (second + 1) + ": Z= " + Z + "\n\n";
            }
        }
        return report;
    }
}

