/*
 * Decompiled with CFR 0.152.
 */
package javanpst.tests.multiple.concordanceCoefficient;

import java.util.Arrays;
import javanpst.data.structures.dataTable.DataTable;
import javanpst.distributions.common.continuous.ChiSquareDistribution;
import javanpst.tests.StatisticalTest;

public class ConcordanceCoefficient
extends StatisticalTest {
    private DataTable data;
    private double[][] samples;
    private double[][] ranks;
    private double[] sumRanks;
    private double S;
    private double Q;
    private double W;
    private double tiesWeight;
    private double pValue;

    public ConcordanceCoefficient() {
        this.setReportFormat();
        this.clearData();
    }

    @Override
    public void clearData() {
        this.data = new DataTable();
        this.performed = false;
        this.dataReady = false;
        this.S = 0.0;
        this.Q = 0.0;
        this.W = 0.0;
        this.samples = null;
        this.ranks = null;
        this.sumRanks = null;
        this.pValue = -1.0;
    }

    public ConcordanceCoefficient(DataTable newData) {
        int i;
        this.setReportFormat();
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() < 3) {
            System.out.println("Concordance coefficient test only can be employed with more than two samples");
            this.clearData();
            return;
        }
        for (i = 0; i < this.data.getColumns(); ++i) {
            if (this.data.getColumnNulls(i) <= 0) continue;
            System.out.println("No null values allowed in this test.");
            this.clearData();
            return;
        }
        this.samples = new double[this.data.getRows()][this.data.getColumns()];
        this.ranks = new double[this.data.getRows()][this.data.getColumns()];
        this.sumRanks = new double[this.data.getColumns()];
        for (i = 0; i < this.data.getRows(); ++i) {
            Arrays.fill(this.ranks[i], -1.0);
            for (int j = 0; j < this.data.getColumns(); ++j) {
                this.samples[i][j] = this.data.get(i, j);
            }
        }
        Arrays.fill(this.sumRanks, 0.0);
        this.dataReady = true;
        this.performed = false;
    }

    public void setData(DataTable newData) {
        int i;
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() < 3) {
            System.out.println("Extended median test only can be employed with more than two samples");
            this.clearData();
            return;
        }
        for (i = 0; i < this.data.getColumns(); ++i) {
            if (this.data.getColumnNulls(i) <= 0) continue;
            System.out.println("No null values allowed in this test.");
            this.clearData();
            return;
        }
        this.samples = new double[this.data.getRows()][this.data.getColumns()];
        this.ranks = new double[this.data.getRows()][this.data.getColumns()];
        this.sumRanks = new double[this.data.getColumns()];
        for (i = 0; i < this.data.getRows(); ++i) {
            Arrays.fill(this.ranks[i], -1.0);
            for (int j = 0; j < this.data.getColumns(); ++j) {
                this.samples[i][j] = this.data.get(i, j);
            }
        }
        Arrays.fill(this.sumRanks, 0.0);
        this.dataReady = true;
        this.performed = false;
    }

    @Override
    public void doTest() {
        if (!this.dataReady) {
            System.out.println("Data is not ready");
            return;
        }
        this.computeRanks();
        for (int i = 0; i < this.data.getRows(); ++i) {
            for (int j = 0; j < this.data.getColumns(); ++j) {
                int n = j;
                this.sumRanks[n] = this.sumRanks[n] + this.ranks[i][j];
            }
        }
        for (int j = 0; j < this.data.getColumns(); ++j) {
            this.S += this.sumRanks[j] * this.sumRanks[j];
        }
        this.S -= (double)(this.data.getRows() * this.data.getRows() * this.data.getColumns()) * ((double)this.data.getColumns() + 1.0) * ((double)this.data.getColumns() + 1.0) / 4.0;
        this.W = 12.0 * this.S;
        this.W /= (double)(this.data.getRows() * this.data.getRows() * this.data.getColumns()) * ((double)(this.data.getColumns() * this.data.getColumns()) - 1.0) - this.tiesWeight;
        this.Q = (double)(this.data.getRows() * (this.data.getColumns() - 1)) * this.W;
        this.computePValue(this.sumRanks.length - 1);
        this.performed = true;
    }

    private double computePValue(int dF) {
        ChiSquareDistribution chi = new ChiSquareDistribution();
        chi.setDegree(dF);
        this.pValue = chi.computeCumulativeProbability(this.Q);
        return this.pValue;
    }

    private void computeRanks() {
        this.tiesWeight = 0.0;
        for (int i = 0; i < this.data.getRows(); ++i) {
            int count;
            double rank = 1.0;
            do {
                double newRank;
                int j;
                double max = Double.MIN_VALUE;
                count = 0;
                for (j = 0; j < this.data.getColumns(); ++j) {
                    if (this.ranks[i][j] == -1.0 && this.samples[i][j] == max) {
                        ++count;
                    }
                    if (this.ranks[i][j] != -1.0 || !(this.samples[i][j] > max)) continue;
                    max = this.samples[i][j];
                    count = 1;
                }
                if (count == 1) {
                    newRank = rank;
                } else {
                    this.tiesWeight += (double)count * ((double)(count * count) - 1.0);
                    newRank = 0.0;
                    for (int k = 0; k < count; ++k) {
                        newRank += rank + (double)k;
                    }
                    newRank /= (double)count;
                }
                for (j = 0; j < this.data.getColumns(); ++j) {
                    if (this.samples[i][j] != max) continue;
                    this.ranks[i][j] = newRank;
                }
            } while ((rank += (double)count) <= (double)this.data.getColumns());
        }
    }

    public double getS() {
        return this.S;
    }

    public double getQ() {
        return this.Q;
    }

    public double getW() {
        return this.W;
    }

    public double getPValue() {
        return this.pValue;
    }

    @Override
    public String printData() {
        String text = "";
        text = text + "\n" + this.data;
        return text;
    }

    @Override
    public String printReport() {
        int j;
        String report = "";
        if (!this.performed) {
            report = report + "The test has not been performed.\n";
            return report;
        }
        report = report + "\n******************\n";
        report = report + "Concordance coefficient based test\n";
        report = report + "******************\n\n";
        report = report + "Sum of ranks:\n";
        for (j = 0; j < this.sumRanks.length; ++j) {
            report = report + "S" + (j + 1) + "\t";
        }
        report = report + "\n";
        for (j = 0; j < this.sumRanks.length; ++j) {
            report = report + this.nf6.format(this.sumRanks[j]) + "\t";
        }
        report = report + "\n";
        report = report + "\n";
        report = report + "S statistic: " + this.nf6.format(this.S) + "\n";
        report = report + "Q statistic: " + this.nf6.format(this.Q) + "\n\n";
        report = report + "W ratio (Kendall's coefficient of concordance): " + this.nf6.format(this.W) + "\n\n";
        report = report + "P-Value computed :" + this.nf6.format(this.pValue) + "\n\n";
        return report;
    }
}

