/*
 * Decompiled with CFR 0.152.
 */
package javanpst.tests.location.wilcoxonRankSumTest;

import java.util.Arrays;
import javanpst.data.structures.dataTable.DataTable;
import javanpst.distributions.common.continuous.NormalDistribution;
import javanpst.distributions.tests.WilcoxonRankSumDistribution;
import javanpst.tests.StatisticalTest;

public class WilcoxonRankSumTest
extends StatisticalTest {
    private WilcoxonRankSumDistribution distribution = WilcoxonRankSumDistribution.getInstance();
    private DataTable data;
    private double[] sample1;
    private double[] sample2;
    private int values1;
    private int values2;
    private double[] combined;
    private boolean[] ties;
    private double WRank;
    private double exactLeftTail;
    private double exactRightTail;
    private double exactDoubleTail;
    private double asymptoticLeftTail;
    private double asymptoticRightTail;
    private double asymptoticDoubleTail;
    String confidenceIntervals95;
    String confidenceIntervals90;
    double exactConfidence90;
    double exactConfidence95;

    public WilcoxonRankSumTest() {
        this.setReportFormat();
        this.clearData();
    }

    @Override
    public void clearData() {
        this.data = new DataTable();
        this.performed = false;
        this.dataReady = false;
        this.WRank = 0.0;
        this.sample1 = null;
        this.sample2 = null;
        this.asymptoticLeftTail = -1.0;
        this.asymptoticRightTail = -1.0;
        this.asymptoticDoubleTail = -1.0;
        this.exactLeftTail = -1.0;
        this.exactRightTail = -1.0;
        this.exactDoubleTail = -1.0;
        this.confidenceIntervals95 = "";
        this.confidenceIntervals90 = "";
        this.exactConfidence90 = -1.0;
        this.exactConfidence95 = -1.0;
    }

    public WilcoxonRankSumTest(DataTable newData) {
        this.setReportFormat();
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() != 2) {
            System.out.println("Wilcoxon Ranks-Sum test only can be employed with two samples");
            this.clearData();
            return;
        }
        int nulls = this.data.getColumnNulls(0);
        this.values1 = this.data.getRows() - nulls;
        this.sample1 = new double[this.values1];
        nulls = this.data.getColumnNulls(1);
        this.values2 = this.data.getRows() - nulls;
        this.sample2 = new double[this.values2];
        int counter1 = 0;
        int counter2 = 0;
        for (int i = 0; i < this.data.getRows(); ++i) {
            double value = this.data.get(i, 0);
            if (value != Double.MIN_VALUE) {
                this.sample1[counter1] = value;
                ++counter1;
            }
            if ((value = this.data.get(i, 1)) == Double.MIN_VALUE) continue;
            this.sample2[counter2] = value;
            ++counter2;
        }
        this.dataReady = true;
        this.performed = false;
    }

    public void setData(DataTable newData) {
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() != 2) {
            System.out.println("Wilcoxon Ranks-Sum test only can be employed with two samples");
            this.clearData();
            return;
        }
        int nulls = this.data.getColumnNulls(0);
        this.values1 = this.data.getRows() - nulls;
        this.sample1 = new double[this.values1];
        nulls = this.data.getColumnNulls(1);
        this.values2 = this.data.getRows() - nulls;
        this.sample2 = new double[this.values2];
        int counter1 = 0;
        int counter2 = 0;
        for (int i = 0; i < this.data.getRows(); ++i) {
            double value = this.data.get(i, 0);
            if (value != Double.MIN_VALUE) {
                this.sample1[counter1] = value;
                ++counter1;
            }
            if ((value = this.data.get(i, 1)) == Double.MIN_VALUE) continue;
            this.sample2[counter2] = value;
            ++counter2;
        }
        this.dataReady = true;
        this.performed = false;
    }

    @Override
    public void doTest() {
        int pointer;
        int i;
        if (!this.dataReady) {
            System.out.println("Data is not ready");
            return;
        }
        this.combined = new double[this.sample1.length + this.sample2.length];
        Arrays.sort(this.sample1);
        Arrays.sort(this.sample2);
        System.arraycopy(this.sample1, 0, this.combined, 0, this.sample1.length);
        System.arraycopy(this.sample2, 0, this.combined, this.sample1.length, this.sample2.length);
        Arrays.sort(this.combined);
        this.ties = new boolean[this.combined.length];
        Arrays.fill(this.ties, false);
        double val = this.combined[0];
        if (this.combined[1] == val) {
            this.ties[0] = true;
        }
        for (i = 1; i < this.combined.length; ++i) {
            if (this.combined[i] == val) {
                this.ties[i] = true;
                this.ties[i - 1] = true;
            }
            val = this.combined[i];
        }
        double[] ranks = new double[this.combined.length];
        for (i = 0; i < this.combined.length; ++i) {
            if (!this.ties[i]) {
                ranks[i] = i + 1;
                continue;
            }
            int j = 1;
            double sumRank = i + 1;
            while (i + j < this.combined.length && this.ties[i + j]) {
                sumRank += (double)(i + 1 + j);
                ++j;
            }
            for (int k = 0; k < j; ++k) {
                ranks[i] = sumRank / (double)j;
                ++i;
            }
            --i;
        }
        this.WRank = 0.0;
        int pointer2 = 0;
        if (this.values1 <= this.values2) {
            for (pointer = 0; pointer < this.sample1.length; ++pointer) {
                while (this.combined[pointer2] != this.sample1[pointer]) {
                    ++pointer2;
                }
                this.WRank += ranks[pointer2];
            }
            this.computePValues();
        } else {
            while (pointer < this.sample2.length) {
                while (this.combined[pointer2] != this.sample2[pointer]) {
                    ++pointer2;
                }
                this.WRank += ranks[pointer2];
                ++pointer;
            }
            this.computePValues();
        }
        this.performed = true;
    }

    private void computePValues() {
        int pointer;
        NormalDistribution normal = new NormalDistribution();
        if (this.values1 <= 10 && this.values2 <= 10) {
            int rank = (int)this.WRank;
            this.exactLeftTail = this.distribution.computeLeftProbability(this.values2, this.values1, rank);
            this.exactRightTail = this.distribution.computeRightProbability(this.values2, this.values1, rank);
            if (this.exactLeftTail == -1.0) {
                this.exactLeftTail = 1.0 - this.exactRightTail;
            }
            if (this.exactRightTail == -1.0) {
                this.exactRightTail = 1.0 - this.exactLeftTail;
            }
            this.exactDoubleTail = Math.min(Math.min(this.exactLeftTail, this.exactRightTail) * 2.0, 1.0);
        }
        int sumTies = 0;
        int actualTie = 0;
        for (pointer = 0; pointer < this.ties.length; ++pointer) {
            if (this.ties[pointer]) {
                ++actualTie;
                continue;
            }
            if (actualTie <= 0) continue;
            sumTies += actualTie * (actualTie * actualTie - 1);
            actualTie = 0;
        }
        if (this.ties[pointer - 1]) {
            sumTies += actualTie * (actualTie * actualTie - 1);
        }
        double denominator = (double)(this.values1 * this.values2 * (this.values1 + this.values2 + 1)) / 12.0;
        denominator -= (double)(this.values1 * this.values2 * sumTies) / (12.0 * (double)(this.values1 + this.values2) * (double)(this.values1 + this.values2 - 1));
        denominator = Math.sqrt(denominator);
        double numerator = this.WRank - 0.5 - (double)this.values1 * ((double)this.values1 + (double)this.values2 + 1.0) / 2.0;
        double z = numerator / denominator;
        this.asymptoticRightTail = 1.0 - normal.getTipifiedProbability(z, false);
        numerator = this.WRank + 0.5 - (double)this.values1 * ((double)this.values2 + (double)this.values1 + 1.0) / 2.0;
        z = numerator / denominator;
        this.asymptoticLeftTail = normal.getTipifiedProbability(z, false);
        this.asymptoticDoubleTail = Math.min(Math.min(this.asymptoticLeftTail, this.asymptoticRightTail) * 2.0, 1.0);
        int criticalN = this.distribution.findCriticalValue(this.values1, this.values2, 0.1);
        criticalN = Math.max(criticalN, 0);
        double[] differences = new double[this.sample1.length * this.sample2.length];
        pointer = 0;
        for (int i = 0; i < this.sample1.length; ++i) {
            for (int j = 0; j < this.sample2.length; ++j) {
                differences[pointer] = this.sample2[j] - this.sample1[i];
                ++pointer;
            }
        }
        Arrays.sort(differences);
        this.confidenceIntervals90 = "[" + this.nf6.format(differences[criticalN - 1]) + "," + this.nf6.format(differences[differences.length - criticalN]) + "]";
        this.exactConfidence90 = 1.0 - this.distribution.inverseFindCriticalValue(this.values1, this.values2, criticalN);
        criticalN = this.distribution.findCriticalValue(this.values1, this.values2, 0.05);
        criticalN = Math.max(criticalN, 0);
        this.confidenceIntervals95 = "[" + this.nf6.format(differences[criticalN - 1]) + "," + this.nf6.format(differences[differences.length - criticalN]) + "]";
        this.exactConfidence95 = 1.0 - this.distribution.inverseFindCriticalValue(this.values1, this.values2, criticalN);
    }

    public double getStatistic1() {
        return this.WRank;
    }

    public double getExactLeftPValue() {
        return this.exactLeftTail;
    }

    public double getExactRightPValue() {
        return this.exactRightTail;
    }

    public double getExactDoublePValue() {
        return this.exactDoubleTail;
    }

    public double getAsymptoticLeftPValue() {
        return this.asymptoticLeftTail;
    }

    public double getAsymptoticRightPValue() {
        return this.asymptoticRightTail;
    }

    public double getExactConfidence90() {
        return this.exactConfidence90;
    }

    public double getExactConfidence95() {
        return this.exactConfidence95;
    }

    public String printConfidenceInterval90() {
        return this.confidenceIntervals90;
    }

    public String printConfidenceInterval95() {
        return this.confidenceIntervals95;
    }

    public double getAsymptoticDoublePValue() {
        return this.asymptoticDoubleTail;
    }

    @Override
    public String printData() {
        String text = "";
        text = text + "\n" + this.data;
        return text;
    }

    @Override
    public String printReport() {
        String report = "";
        if (!this.performed) {
            report = report + "The test has not been performed.\n";
            return report;
        }
        report = report + "\n*****************************\n";
        report = report + "Wilcoxon Ranks-Sum test\n";
        report = report + "*****************************\n\n";
        report = report + "Wilcoxon Statistic X: " + this.nf6.format(this.WRank) + "\n\n";
        if (this.values1 <= 10 && this.values2 <= 10) {
            report = report + "Exact P-Value (left tail): " + this.nf6.format(this.exactLeftTail) + "\n";
            report = report + "Exact P-Value (right tail): " + this.nf6.format(this.exactRightTail) + "\n";
            report = report + "Exact P-Value (double tail): " + this.nf6.format(this.exactDoubleTail) + "\n\n";
            report = report + "Confidence interval for median difference (Alpha: 0.90): " + this.confidenceIntervals90 + " Exact confidence: " + this.nf6.format(this.exactConfidence90) + "\n";
            report = report + "Confidence interval for median difference (Alpha: 0.95): " + this.confidenceIntervals95 + " Exact confidence: " + this.nf6.format(this.exactConfidence95) + "\n\n";
        } else {
            report = report + "Using normal approximation for more than 10 values for sample 1 or 2\n";
        }
        report = report + "Asymptotic P-Value (left tail): " + this.nf6.format(this.asymptoticLeftTail) + "\n";
        report = report + "Asymptotic P-Value (right tail): " + this.nf6.format(this.asymptoticRightTail) + "\n";
        report = report + "Asymptotic P-Value (double tail): " + this.nf6.format(this.asymptoticDoubleTail) + "\n\n";
        return report;
    }
}

