/*
 * Decompiled with CFR 0.152.
 */
package javanpst.tests.goodness.A_DTest;

import javanpst.data.structures.sequence.NumericSequence;
import javanpst.distributions.common.continuous.ChiSquareDistribution;
import javanpst.distributions.common.continuous.ExponentialDistribution;
import javanpst.distributions.common.continuous.GammaDistribution;
import javanpst.distributions.common.continuous.LaplaceDistribution;
import javanpst.distributions.common.continuous.LogisticDistribution;
import javanpst.distributions.common.continuous.NormalDistribution;
import javanpst.distributions.common.continuous.UniformCDistribution;
import javanpst.distributions.common.continuous.WeibullDistribution;
import javanpst.tests.StatisticalTest;

public class A_DTest
extends StatisticalTest {
    private static final int COMPLETE = 0;
    private static final int NORMAL_NO_MEAN = 1;
    private static final int NORMAL_NO_VARIANCE = 2;
    private static final int NORMAL_NO_MEAN_VARIANCE = 3;
    private static final int EXPONENTIAL_NO_MEAN = 4;
    private NumericSequence sequence;
    private double[] F0;
    private ExponentialDistribution exponential;
    private NormalDistribution normal;
    private ChiSquareDistribution chisquare;
    private UniformCDistribution uniform;
    private GammaDistribution gamma;
    private LaplaceDistribution laplace;
    private LogisticDistribution logistic;
    private WeibullDistribution weibull;
    private int typeTest;
    private int typeDistribution;
    private double mean;
    private double sigma;
    private boolean distributionReady;
    private double W2;
    private double A;
    private double pValue;

    public A_DTest() {
        this.setReportFormat();
        this.clearData();
    }

    @Override
    public void clearData() {
        this.sequence = new NumericSequence();
        this.performed = false;
        this.dataReady = false;
        this.distributionReady = false;
        this.typeTest = -1;
        this.typeDistribution = -1;
        this.W2 = 0.0;
        this.A = 0.0;
        this.F0 = null;
        this.pValue = -1.0;
    }

    public A_DTest(NumericSequence newSequence) {
        this.setReportFormat();
        this.sequence = new NumericSequence(newSequence);
        this.sequence.sort();
        this.F0 = new double[this.sequence.size()];
        this.performed = false;
        this.dataReady = true;
        this.distributionReady = false;
    }

    public void setData(NumericSequence newSequence) {
        this.sequence = new NumericSequence(newSequence);
        this.sequence.sort();
        this.F0 = new double[this.sequence.size()];
        this.performed = false;
        this.dataReady = true;
        this.distributionReady = false;
    }

    public void adjustNormal() {
        this.typeDistribution = 4;
        this.typeTest = 3;
        this.normal = new NormalDistribution();
        this.estimateParameters();
        this.normal.setMean(this.mean);
        this.normal.setS(this.sigma);
        this.distributionReady = true;
    }

    public void adjustNormalMean(double m) {
        this.typeDistribution = 4;
        this.typeTest = 2;
        this.normal = new NormalDistribution();
        this.estimateParameters();
        this.normal.setMean(m);
        this.normal.setS(this.sigma);
        this.distributionReady = true;
    }

    public void adjustNormalVariance(double s) {
        this.typeDistribution = 4;
        this.typeTest = 1;
        this.normal = new NormalDistribution();
        this.estimateParameters();
        this.normal.setMean(this.mean);
        this.normal.setS(s);
        this.distributionReady = true;
    }

    public void adjustNormal(double m, double s) {
        this.typeDistribution = 4;
        this.typeTest = 0;
        this.normal = new NormalDistribution();
        this.normal.setMean(m);
        this.normal.setS(s);
        this.distributionReady = true;
    }

    public void adjustExponential() {
        this.typeDistribution = 7;
        this.typeTest = 4;
        this.exponential = new ExponentialDistribution();
        this.estimateParameters();
        this.exponential.setMean(this.mean);
        this.distributionReady = true;
    }

    public void adjustExponential(double m) {
        this.typeDistribution = 7;
        this.typeTest = 0;
        this.exponential = new ExponentialDistribution();
        this.exponential.setMean(m);
        this.distributionReady = true;
    }

    public void adjustUniform(double start, double end) {
        this.typeDistribution = 5;
        this.typeTest = 0;
        this.uniform = new UniformCDistribution();
        this.uniform.setStart(start);
        this.uniform.setEnd(end);
        this.distributionReady = true;
    }

    public void adjustChiSquare(int freedom) {
        this.typeDistribution = 6;
        this.typeTest = 0;
        this.chisquare = new ChiSquareDistribution();
        this.chisquare.setDegree(freedom);
        this.distributionReady = true;
    }

    public void adjustGamma(double K, double lambda) {
        this.typeDistribution = 8;
        this.typeTest = 0;
        this.gamma = new GammaDistribution();
        this.gamma.setK(K);
        this.gamma.setLambda(lambda);
        this.distributionReady = true;
    }

    public void adjustLaplace(double mean, double scale) {
        this.typeDistribution = 9;
        this.typeTest = 0;
        this.laplace = new LaplaceDistribution();
        this.laplace.setMean(mean);
        this.laplace.setScale(scale);
        this.distributionReady = true;
    }

    public void adjustLogistic(double mean, double S) {
        this.typeDistribution = 10;
        this.typeTest = 0;
        this.logistic = new LogisticDistribution();
        this.logistic.setMean(mean);
        this.logistic.setS(S);
        this.distributionReady = true;
    }

    public void adjustWeibull(double K, double lambda) {
        this.typeDistribution = 11;
        this.typeTest = 0;
        this.weibull = new WeibullDistribution();
        this.weibull.setK(K);
        this.weibull.setLambda(lambda);
        this.distributionReady = true;
    }

    @Override
    public void doTest() {
        double n = this.sequence.size();
        if (!this.dataReady) {
            System.out.println("Data is not ready");
            return;
        }
        if (!this.distributionReady) {
            System.out.println("Distribution to fit is not set");
            return;
        }
        this.F0 = new double[this.sequence.size()];
        int i = 0;
        while ((double)i < n) {
            this.F0[i] = this.computeExpected(this.sequence.getSequence().get(i));
            ++i;
        }
        this.W2 = 0.0;
        i = 0;
        while ((double)i < n) {
            double term1 = 2.0 * (double)(i + 1) - 1.0;
            double term2 = Math.log(this.F0[i]);
            double term3 = Math.log(1.0 - this.F0[(int)n - (i + 1)]);
            this.W2 += term1 * (term2 + term3);
            ++i;
        }
        this.W2 *= -1.0 / n;
        this.W2 -= n;
        switch (this.typeTest) {
            case 4: {
                this.A = this.W2 * (1.0 + 0.3 / n);
                break;
            }
            case 3: {
                this.A = this.W2 * (1.0 + 0.75 / n + 2.25 / (n * n));
                break;
            }
            default: {
                this.A = this.W2;
            }
        }
        this.pValue = this.computePValue(this.A);
        this.performed = true;
    }

    private double computePValue(double A) {
        double[][] criticalValues = new double[][]{{3.857, 3.07, 2.492, 1.933, 1.61}, {1.551, 1.285, 1.087, 0.894, 0.782}, {3.702, 2.898, 2.308, 1.743, 1.43}, {1.035, 0.873, 0.752, 0.631, 0.561}, {1.959, 1.591, 1.321, 1.062, 0.916}};
        double[] criticalLevels = new double[]{0.01, 0.025, 0.05, 0.1, 0.15};
        for (int i = 0; i < 5; ++i) {
            if (!(A >= criticalValues[this.typeTest][i])) continue;
            return criticalLevels[i];
        }
        return 1.0;
    }

    private double computeExpected(double value) {
        double prob = 0.0;
        switch (this.typeDistribution) {
            case 4: {
                prob = this.normal.computeCumulativeProbability(value);
                break;
            }
            case 5: {
                prob = this.uniform.computeCumulativeProbability(value);
                break;
            }
            case 6: {
                prob = this.chisquare.computeCumulativeProbability(value);
                break;
            }
            case 7: {
                prob = this.exponential.computeCumulativeProbability(value);
                break;
            }
            case 8: {
                prob = this.gamma.computeCumulativeProbability(value);
                break;
            }
            case 9: {
                prob = this.laplace.computeCumulativeProbability(value);
                break;
            }
            case 10: {
                prob = this.logistic.computeCumulativeProbability(value);
                break;
            }
            case 11: {
                prob = this.weibull.computeCumulativeProbability(value);
            }
        }
        return prob;
    }

    private void estimateParameters() {
        this.mean = 0.0;
        this.sigma = 0.0;
        for (double d : this.sequence.getSequence()) {
            this.mean += d;
        }
        this.mean /= (double)this.sequence.size();
        for (double d : this.sequence.getSequence()) {
            this.sigma += (d - this.mean) * (d - this.mean);
        }
        this.sigma /= (double)this.sequence.size() - 1.0;
        this.sigma = Math.sqrt(this.sigma);
    }

    public double W2() {
        return this.A;
    }

    public double getA() {
        return this.A;
    }

    public double getPValue() {
        return this.pValue;
    }

    @Override
    public String printData() {
        String text = "";
        text = text + "\n" + this.sequence;
        return text;
    }

    @Override
    public String printReport() {
        String report = "";
        if (!this.performed) {
            report = report + "The test has not been performed.\n";
            return report;
        }
        report = report + "\n************\n";
        report = report + "Anderson-Darling goodness of fit test\n";
        report = report + "**************\n\n";
        switch (this.typeDistribution) {
            case 4: {
                report = report + "Fitting data to Normal distribution with Mean = " + this.nf6.format(this.normal.getMean()) + " and Sigma = " + this.nf6.format(this.normal.getSigma()) + "\n\n";
                break;
            }
            case 7: {
                report = report + "Fitting data to Exponential distribution with Mean = " + this.nf6.format(this.exponential.getMean()) + "\n\n";
                break;
            }
            case 5: {
                report = report + "Fitting data to Uniform distribution between [" + this.nf6.format(this.uniform.getStart()) + "," + this.nf6.format(this.uniform.getEnd()) + "]\n\n";
                break;
            }
            case 6: {
                report = report + "Fitting data to Chi-square distribution with " + this.nf6.format(this.chisquare.getDegree()) + " degrees of freedom\n\n";
                break;
            }
            case 8: {
                report = report + "Fitting data to Gamma distribution with K = " + this.nf6.format(this.gamma.getK()) + " and Lambda = " + this.nf6.format(this.gamma.getLambda()) + "\n\n";
                break;
            }
            case 11: {
                report = report + "Fitting data to Weibull distribution with K = " + this.nf6.format(this.weibull.getK()) + " and Lambda = " + this.nf6.format(this.weibull.getLambda()) + "\n\n";
                break;
            }
            case 9: {
                report = report + "Fitting data to Laplace distribution with Mean = " + this.nf6.format(this.laplace.getMean()) + " and Scale = " + this.nf6.format(this.laplace.getScale()) + "\n\n";
                break;
            }
            case 10: {
                report = report + "Fitting data to Logistic distribution with Mean = " + this.nf6.format(this.logistic.getMean()) + " and S = " + this.nf6.format(this.logistic.getS()) + "\n\n";
            }
        }
        report = report + "W2 Statistic: " + this.nf6.format(this.W2) + "\n";
        report = report + "A Statistic: " + this.nf6.format(this.A) + "\n\n";
        report = report + "Exact p-value : <= " + this.nf6.format(this.pValue) + "\n";
        return report;
    }
}

