/*
 * Decompiled with CFR 0.152.
 */
package javanpst.tests.equality.extendedMedianTest;

import java.util.Arrays;
import javanpst.data.structures.dataTable.DataTable;
import javanpst.distributions.common.continuous.ChiSquareDistribution;
import javanpst.tests.StatisticalTest;

public class ExtendedMedianTest
extends StatisticalTest {
    private DataTable data;
    private double[][] samples;
    private double N;
    private double[][] position;
    private double median;
    private double[] combined;
    private double Q;
    private double improvedQ;
    private double pValue;

    public ExtendedMedianTest() {
        this.setReportFormat();
        this.clearData();
    }

    @Override
    public void clearData() {
        this.data = new DataTable();
        this.performed = false;
        this.dataReady = false;
        this.Q = 0.0;
        this.improvedQ = 0.0;
        this.median = 0.0;
        this.samples = null;
        this.position = null;
        this.pValue = -1.0;
    }

    public ExtendedMedianTest(DataTable newData) {
        int i;
        this.setReportFormat();
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() < 3) {
            System.out.println("Extended median test only can be employed with more than two samples");
            this.clearData();
            return;
        }
        for (i = 0; i < this.data.getColumns(); ++i) {
            if (this.data.getColumnNulls(i) <= 0) continue;
            System.out.println("No null values allowed in this test.");
            this.clearData();
            return;
        }
        this.samples = new double[this.data.getRows()][this.data.getColumns()];
        this.combined = new double[this.data.getRows() * this.data.getColumns()];
        this.position = new double[2][this.data.getColumns()];
        Arrays.fill(this.position[0], 0.0);
        Arrays.fill(this.position[1], 0.0);
        for (i = 0; i < this.data.getRows(); ++i) {
            for (int j = 0; j < this.data.getColumns(); ++j) {
                this.samples[i][j] = this.data.get(i, j);
                this.combined[i * this.data.getColumns() + j] = this.data.get(i, j);
            }
        }
        Arrays.sort(this.combined);
        this.dataReady = true;
        this.performed = false;
    }

    public void setData(DataTable newData) {
        int i;
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() < 3) {
            System.out.println("Extended median test only can be employed with more than two samples");
            this.clearData();
            return;
        }
        for (i = 0; i < this.data.getColumns(); ++i) {
            if (this.data.getColumnNulls(i) <= 0) continue;
            System.out.println("No null values allowed in this test.");
            this.clearData();
            return;
        }
        this.samples = new double[this.data.getRows()][this.data.getColumns()];
        this.combined = new double[this.data.getRows() * this.data.getColumns()];
        this.position = new double[2][this.data.getColumns()];
        Arrays.fill(this.position[0], 0.0);
        Arrays.fill(this.position[1], 0.0);
        for (i = 0; i < this.data.getRows(); ++i) {
            for (int j = 0; j < this.data.getColumns(); ++j) {
                this.samples[i][j] = this.data.get(i, j);
                this.combined[i * this.data.getColumns() + j] = this.data.get(i, j);
            }
        }
        Arrays.sort(this.combined);
        this.dataReady = true;
        this.performed = false;
    }

    @Override
    public void doTest() {
        int j;
        if (!this.dataReady) {
            System.out.println("Data is not ready");
            return;
        }
        this.N = this.data.getRows() * this.data.getColumns();
        double t = this.N % 2.0 == 0.0 ? this.N / 2.0 : (this.N - 1.0) / 2.0;
        if (this.N % 2.0 == 0.0) {
            int index = (int)((this.N - 1.0) / 2.0);
            this.median = this.combined[index];
            this.median += this.combined[index + 1];
            this.median /= 2.0;
        } else {
            this.median = this.combined[(int)((this.N - 1.0) / 2.0)];
        }
        for (j = 0; j < this.samples[0].length; ++j) {
            for (int i = 0; i < this.samples.length; ++i) {
                if (this.samples[i][j] < this.median) {
                    double[] dArray = this.position[0];
                    int n = j;
                    dArray[n] = dArray[n] + 1.0;
                    continue;
                }
                double[] dArray = this.position[1];
                int n = j;
                dArray[n] = dArray[n] + 1.0;
            }
        }
        double acum = 0.0;
        for (j = 0; j < this.samples[0].length; ++j) {
            double aux = this.position[0][j] - (double)this.samples.length * t / this.N;
            aux = aux * aux / (double)this.samples.length;
            acum += aux;
        }
        this.Q = this.N * this.N / (t * (this.N - t)) * acum;
        this.improvedQ = (this.N - 1.0) * this.Q / this.N;
        int dF = this.samples[0].length - 1;
        this.computePValues(dF);
        this.performed = true;
    }

    private void computePValues(int dF) {
        ChiSquareDistribution chi = new ChiSquareDistribution();
        chi.setDegree(dF);
        this.pValue = chi.computeCumulativeProbability(this.improvedQ);
    }

    public double getQ() {
        return this.Q;
    }

    public double getImprovedQ() {
        return this.improvedQ;
    }

    public double getMedian() {
        return this.median;
    }

    public double getPValue() {
        return this.pValue;
    }

    @Override
    public String printData() {
        String text = "";
        text = text + "\n" + this.data;
        return text;
    }

    @Override
    public String printReport() {
        int j;
        String report = "";
        if (!this.performed) {
            report = report + "The test has not been performed.\n";
            return report;
        }
        report = report + "\n***************************************\n";
        report = report + "Extended median test for k independent samples\n";
        report = report + "***************************************\n\n";
        report = report + "median value: " + this.nf6.format(this.median) + "\n";
        report = report + "Q statistic: " + this.nf6.format(this.Q) + "\n";
        report = report + "Improved Q statistic: " + this.nf6.format(this.improvedQ) + "\n\n";
        report = report + "P-Value computed :" + this.nf6.format(this.pValue) + "\n\n";
        report = report + "Position with respect to median\n\n";
        for (j = 0; j < this.position[0].length; ++j) {
            report = report + "S" + (j + 1) + "\t";
        }
        report = report + "\n";
        for (j = 0; j < this.position[0].length; ++j) {
            report = report + this.position[0][j] + "\t";
        }
        report = report + "\n";
        for (j = 0; j < this.position[1].length; ++j) {
            report = report + this.position[1][j] + "\t";
        }
        report = report + "\n\n";
        return report;
    }
}

