/*
 * Decompiled with CFR 0.152.
 */
package javanpst.tests.countData.fisherTest;

import javanpst.data.structures.dataTable.DataTable;
import javanpst.distributions.tests.FisherDistribution;
import javanpst.tests.StatisticalTest;

public class FisherTest
extends StatisticalTest {
    private FisherDistribution distribution = FisherDistribution.getInstance();
    private DataTable data;
    private double[][] contingencyTable;
    private int N;
    private int Y;
    private int n00;
    private int n1;
    private int n2;
    private double exactLeftPValue;
    private double exactRightPValue;
    private double Q;
    private double asymptoticPValue;

    public FisherTest() {
        this.setReportFormat();
        this.clearData();
    }

    @Override
    public void clearData() {
        this.data = new DataTable();
        this.performed = false;
        this.dataReady = false;
        this.Q = 0.0;
        this.contingencyTable = null;
        this.asymptoticPValue = -1.0;
        this.exactLeftPValue = -1.0;
        this.exactRightPValue = -1.0;
    }

    public FisherTest(DataTable newData) {
        int i;
        this.setReportFormat();
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() > 2 || this.data.getColumns() < 2 || this.data.getRows() > 2 || this.data.getRows() < 2) {
            System.out.println("Data must be represented in two rows and two columns");
            this.clearData();
            return;
        }
        for (i = 0; i < this.data.getColumns(); ++i) {
            if (this.data.getColumnNulls(i) <= 0) continue;
            System.out.println("No null values allowed in this test.");
            this.clearData();
            return;
        }
        this.contingencyTable = new double[this.data.getRows()][this.data.getColumns()];
        for (i = 0; i < this.data.getRows(); ++i) {
            for (int j = 0; j < this.data.getColumns(); ++j) {
                this.contingencyTable[i][j] = this.data.get(i, j);
            }
        }
        this.dataReady = true;
        this.performed = false;
    }

    public void setData(DataTable newData) {
        int i;
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() > 2 || this.data.getColumns() < 2 || this.data.getRows() > 2 || this.data.getRows() < 2) {
            System.out.println("Data must be represented in two rows and two columns");
            this.clearData();
            return;
        }
        for (i = 0; i < newData.getColumns(); ++i) {
            if (newData.getRowNulls(i) <= 0) continue;
            System.out.println("No null values allowed in this test.");
            this.clearData();
            return;
        }
        this.contingencyTable = new double[this.data.getRows()][this.data.getColumns()];
        for (i = 0; i < this.data.getRows(); ++i) {
            for (int j = 0; j < this.data.getColumns(); ++j) {
                this.contingencyTable[i][j] = this.data.get(i, j);
            }
        }
        this.dataReady = true;
        this.performed = false;
    }

    @Override
    public void doTest() {
        if (!this.dataReady) {
            System.out.println("Data is not ready");
            return;
        }
        this.N = (int)this.contingencyTable[0][0] + (int)this.contingencyTable[0][1] + (int)this.contingencyTable[1][0] + (int)this.contingencyTable[1][1];
        this.n1 = (int)this.contingencyTable[0][0] + (int)this.contingencyTable[0][1];
        this.n2 = (int)this.contingencyTable[1][0] + (int)this.contingencyTable[1][1];
        this.Y = (int)this.contingencyTable[0][0] + (int)this.contingencyTable[1][0];
        this.n00 = (int)this.contingencyTable[0][0];
        this.exactLeftPValue = this.distribution.computeLeftExactProbability(this.N, this.n1, this.n2, this.Y, this.n00);
        this.exactRightPValue = this.distribution.computeRightExactProbability(this.N, this.n1, this.n2, this.Y, this.n00);
        this.Q = 0.0;
        double[] sumRow = new double[]{this.n1, this.n2};
        double[] sumColumn = new double[]{this.Y, this.N - this.Y};
        for (int i = 0; i < this.contingencyTable.length; ++i) {
            for (int j = 0; j < this.contingencyTable[0].length; ++j) {
                double term = (double)this.N * this.contingencyTable[i][j] - sumRow[i] * sumColumn[j];
                term *= term;
                this.Q += (term /= (double)this.N * sumRow[i] * sumColumn[j]);
            }
        }
        int dF = (sumRow.length - 1) * (sumColumn.length - 1);
        this.asymptoticPValue = this.distribution.computeAsymptoticProbability(this.Q, dF);
        this.performed = true;
    }

    public double getQ() {
        return this.Q;
    }

    public double getExactLeftPValue() {
        return this.exactLeftPValue;
    }

    public double getExactRightPValue() {
        return this.exactRightPValue;
    }

    public double getAsymptoticPValue() {
        return this.asymptoticPValue;
    }

    @Override
    public String printData() {
        String text = "";
        text = text + "\n" + this.data;
        return text;
    }

    @Override
    public String printReport() {
        String report = "";
        if (!this.performed) {
            report = report + "The test has not been performed.\n";
            return report;
        }
        report = report + "\n*************\n";
        report = report + "Fisher's exact Test\n";
        report = report + "*************\n\n";
        report = report + "Exact Left P-Value: " + this.nf6.format(this.exactLeftPValue) + "\n";
        report = report + "Exact Right P-Value: " + this.nf6.format(this.exactRightPValue) + "\n\n";
        report = report + "Q statistic: " + this.nf6.format(this.Q) + "\n";
        report = report + "Asymptotic P-Value: " + this.nf6.format(this.asymptoticPValue) + "\n\n";
        report = report + "Contingency table\n\n";
        report = report + this.contingencyTable[0][0] + "\t" + this.contingencyTable[0][1] + "\n";
        report = report + this.contingencyTable[1][0] + "\t" + this.contingencyTable[1][1] + "\n";
        return report;
    }
}

