/*
 * Decompiled with CFR 0.152.
 */
package javanpst.distributions.tests;

import java.io.IOException;
import javanpst.data.distributions.incompleteTable.Incomplete2KeyTable;
import javanpst.data.readers.distributionReaders.WilcoxonReaderFormat;
import javanpst.distributions.common.continuous.NormalDistribution;
import javanpst.distributions.tests.TestDistribution;
import javanpst.utils.Formats;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WilcoxonDistribution
extends TestDistribution {
    private static Incomplete2KeyTable table;
    private static NormalDistribution normal;

    private WilcoxonDistribution() {
        this.initialize();
    }

    public static WilcoxonDistribution getInstance() {
        return SingletonHolder.distribution;
    }

    @Override
    protected void generateTables() {
        table = new Incomplete2KeyTable(505, 51);
        this.loadFiles();
    }

    @Override
    protected void loadFiles() {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser sp = spf.newSAXParser();
            sp.parse(this.getClass().getResourceAsStream("/tables/Wilcoxon/WilcoxonTable.xml"), (DefaultHandler)new WilcoxonReaderFormat());
        }
        catch (ParserConfigurationException e) {
            System.err.println("Parser error");
        }
        catch (SAXException e2) {
            System.err.println("SAX error: " + e2.getStackTrace());
        }
        catch (IOException e3) {
            System.err.println("Input/Output error: " + e3.getMessage());
        }
    }

    public static Incomplete2KeyTable getTable() {
        return table;
    }

    public double computeExactProbability(int N, double R) {
        double pValue;
        if (N > 50) {
            return -1.0;
        }
        try {
            if (Formats.isInt(R)) {
                pValue = table.get((int)R, N);
                if (pValue == -1.0) {
                    pValue = 1.0;
                }
            } else {
                double value2;
                double value1 = table.get((int)Math.ceil(R), N);
                if (value1 == -1.0) {
                    value1 = 1.0;
                }
                if ((value2 = table.get((int)Math.floor(R), N)) == -1.0) {
                    value2 = 1.0;
                }
                pValue = (value1 + value2) / 2.0;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 1.0;
        }
        return pValue;
    }

    public double computeAsymptoticDoubleTailProbability(int N, double R, double ties) {
        normal = new NormalDistribution();
        double numerator1 = R - 0.5 - (double)N * ((double)N + 1.0) / 4.0;
        double numerator2 = R + 0.5 - (double)N * ((double)N + 1.0) / 4.0;
        double denominator = Math.sqrt((double)N * ((double)N + 1.0) * ((double)(2 * N) + 1.0) / 24.0);
        double z = numerator1 / (denominator -= ties / 48.0);
        double rightTail = 1.0 - normal.getTipifiedProbability(z, false);
        z = numerator2 / denominator;
        double leftTail = normal.getTipifiedProbability(z, false);
        double doubleTail = Math.min(leftTail, rightTail) * 2.0;
        doubleTail = Math.min(doubleTail, 1.0);
        return doubleTail;
    }

    public double computeAsymptoticRightTailProbability(int N, double R, double ties) {
        normal = new NormalDistribution();
        double numerator2 = R - 0.5 - (double)N * ((double)N + 1.0) / 4.0;
        double denominator = Math.sqrt((double)N * ((double)N + 1.0) * ((double)(2 * N) + 1.0) / 24.0);
        double z = numerator2 / (denominator -= ties / 48.0);
        double rightTail = 1.0 - normal.getTipifiedProbability(z, false);
        return rightTail;
    }

    public double computeAsymptoticLeftTailProbability(int N, double R, double ties) {
        normal = new NormalDistribution();
        double numerator1 = R + 0.5 - (double)N * ((double)N + 1.0) / 4.0;
        double denominator = Math.sqrt((double)N * ((double)N + 1.0) * ((double)(2 * N) + 1.0) / 24.0);
        double z = numerator1 / (denominator -= ties / 48.0);
        double leftTail = normal.getTipifiedProbability(z, false);
        return leftTail;
    }

    private static class SingletonHolder {
        public static final WilcoxonDistribution distribution = new WilcoxonDistribution();

        private SingletonHolder() {
        }
    }
}

