/*
 * Decompiled with CFR 0.152.
 */
package javanpst.distributions.tests;

import java.io.IOException;
import javanpst.data.distributions.aproximateTable.Aproximate1KeyTable;
import javanpst.data.distributions.criticalTable.Critical1KeyTable;
import javanpst.data.readers.distributionReaders.SpearmanExactReaderFormat;
import javanpst.data.readers.distributionReaders.SpearmanQuantileReaderFormat;
import javanpst.distributions.common.continuous.NormalDistribution;
import javanpst.distributions.tests.TestDistribution;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SpearmanDistribution
extends TestDistribution {
    private static Aproximate1KeyTable exactTable;
    private static Critical1KeyTable table;
    private static NormalDistribution normal;

    private SpearmanDistribution() {
        this.initialize();
    }

    public static SpearmanDistribution getInstance() {
        return SingletonHolder.distribution;
    }

    @Override
    protected void generateTables() {
        double[] tags = new double[]{0.1, 0.05, 0.025, 0.01, 0.005, 0.001};
        table = new Critical1KeyTable(31, tags);
        exactTable = new Aproximate1KeyTable(11, 85);
        this.loadFiles();
        normal = new NormalDistribution();
    }

    @Override
    protected void loadFiles() {
        SAXParser sp;
        SAXParserFactory spf;
        try {
            spf = SAXParserFactory.newInstance();
            sp = spf.newSAXParser();
            sp.parse(this.getClass().getResourceAsStream("/tables/Spearman/QuantileTable.xml"), (DefaultHandler)new SpearmanQuantileReaderFormat());
        }
        catch (ParserConfigurationException e) {
            System.err.println("Parser error");
        }
        catch (SAXException e2) {
            System.err.println("SAX error: " + e2.getStackTrace());
        }
        catch (IOException e3) {
            System.err.println("Input/Output error: " + e3.getMessage());
        }
        try {
            spf = SAXParserFactory.newInstance();
            sp = spf.newSAXParser();
            sp.parse(this.getClass().getResourceAsStream("/tables/Spearman/ExactTable.xml"), (DefaultHandler)new SpearmanExactReaderFormat());
        }
        catch (ParserConfigurationException e) {
            System.err.println("Parser error");
        }
        catch (SAXException e2) {
            System.err.println("SAX error: " + e2.getStackTrace());
        }
        catch (IOException e3) {
            System.err.println("Input/Output error: " + e3.getMessage());
        }
    }

    public static Critical1KeyTable getCriticalTable() {
        return table;
    }

    public static Aproximate1KeyTable getExactTable() {
        return exactTable;
    }

    public double computeExactProbability(int n, double T) {
        T = Math.abs(T);
        return exactTable.get(n, T);
    }

    public double computeAproximatedProbability(int n, double T) {
        T = Math.abs(T);
        if (n > 10 && n < 31) {
            for (int i = 5; i > -1; --i) {
                if (!(T >= table.get(n, i))) continue;
                return table.getHeader(i);
            }
        }
        return 1.0;
    }

    public double computeAsymptoticProbability(double Z, boolean dependence) {
        return normal.getTipifiedProbability(Z, dependence);
    }

    private static class SingletonHolder {
        public static final SpearmanDistribution distribution = new SpearmanDistribution();

        private SingletonHolder() {
        }
    }
}

