/*
 * Decompiled with CFR 0.152.
 */
package javanpst.distributions.tests;

import java.io.IOException;
import javanpst.data.distributions.criticalTable.Critical1KeyTable;
import javanpst.data.readers.distributionReaders.RVNDistributionReaderFormat;
import javanpst.distributions.tests.TestDistribution;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RVNDistribution
extends TestDistribution {
    private static Critical1KeyTable table;

    private RVNDistribution() {
        this.initialize();
    }

    public static RVNDistribution getInstance() {
        return SingletonHolder.distribution;
    }

    @Override
    protected void generateTables() {
        double[] tags = new double[]{0.005, 0.01, 0.025, 0.05, 0.1};
        table = new Critical1KeyTable(101, tags);
        this.loadFiles();
    }

    @Override
    protected void loadFiles() {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser sp = spf.newSAXParser();
            sp.parse(this.getClass().getResourceAsStream("/tables/RanksVonNeumann/RanksVonNeumann.xml"), (DefaultHandler)new RVNDistributionReaderFormat());
        }
        catch (ParserConfigurationException e) {
            System.err.println("Parser error");
        }
        catch (SAXException e2) {
            System.err.println("SAX error: " + e2.getStackTrace());
        }
        catch (IOException e3) {
            System.err.println("Input/Output error: " + e3.getMessage());
        }
    }

    public static Critical1KeyTable getTable() {
        return table;
    }

    public double computeLeftProbability(int n, double RVN) {
        if (table.get(n, 0) == -1.0) {
            return -1.0;
        }
        for (int i = 0; i < 5; ++i) {
            if (!(RVN <= table.get(n, i))) continue;
            return table.getHeader(i);
        }
        return 1.0;
    }

    public double computeRightProbability(int n, double RVN) {
        if (table.get(n, 0) == -1.0) {
            return -1.0;
        }
        for (int i = 0; i < 5; ++i) {
            if (!(RVN >= 2.0 - table.get(n, i) + 2.0)) continue;
            return table.getHeader(i);
        }
        return 1.0;
    }

    private static class SingletonHolder {
        public static final RVNDistribution distribution = new RVNDistribution();

        private SingletonHolder() {
        }
    }
}

