/*
 * Decompiled with CFR 0.152.
 */
package javanpst.distributions.tests;

import java.io.IOException;
import javanpst.data.distributions.criticalTable.Critical2KeyTable;
import javanpst.data.readers.distributionReaders.PageReaderFormat;
import javanpst.distributions.common.continuous.NormalDistribution;
import javanpst.distributions.tests.TestDistribution;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PageDistribution
extends TestDistribution {
    private static NormalDistribution normal;
    private static Critical2KeyTable table;

    private PageDistribution() {
        this.initialize();
    }

    public static PageDistribution getInstance() {
        return SingletonHolder.distribution;
    }

    @Override
    protected void generateTables() {
        double[] tags = new double[]{0.001, 0.01, 0.05};
        table = new Critical2KeyTable(13, 9, tags);
        this.loadFiles();
        normal = new NormalDistribution();
    }

    @Override
    protected void loadFiles() {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser sp = spf.newSAXParser();
            sp.parse(this.getClass().getResourceAsStream("/tables/Page/PageTest.xml"), (DefaultHandler)new PageReaderFormat());
        }
        catch (ParserConfigurationException e) {
            System.err.println("Parser error");
        }
        catch (SAXException e2) {
            System.err.println("SAX error: " + e2.getStackTrace());
        }
        catch (IOException e3) {
            System.err.println("Input/Output error: " + e3.getMessage());
        }
    }

    public static Critical2KeyTable getTable() {
        return table;
    }

    public double computeExactProbability(int n, int k, double L) {
        if (n <= 8 && n >= 3 && k <= 12 && k >= 2) {
            return table.estimate(k, n, L);
        }
        return -1.0;
    }

    public double computeAsymptoticProbability(int n, int k, double L) {
        double numerator = 12.0 * (L - 0.5) - 3.0 * (double)k * (double)n * ((double)n + 1.0) * ((double)n + 1.0);
        double denominator = (double)(n * (n + 1)) * Math.sqrt((double)k * ((double)n - 1.0));
        double Z = numerator / denominator;
        return normal.getTipifiedProbability(Z, true);
    }

    private static class SingletonHolder {
        public static final PageDistribution distribution = new PageDistribution();

        private SingletonHolder() {
        }
    }
}

