/*
 * Decompiled with CFR 0.152.
 */
package javanpst.distributions.tests;

import javanpst.distributions.common.continuous.ChiSquareDistribution;
import javanpst.distributions.common.continuous.NormalDistribution;
import javanpst.distributions.common.discrete.BinomialDistribution;
import javanpst.distributions.tests.TestDistribution;

public class McNemarDistribution
extends TestDistribution {
    private BinomialDistribution binom;
    private NormalDistribution normal;
    private ChiSquareDistribution chi;

    private McNemarDistribution() {
        this.initialize();
    }

    public static McNemarDistribution getInstance() {
        return SingletonHolder.distribution;
    }

    @Override
    protected void generateTables() {
        this.binom = new BinomialDistribution();
        this.binom.setP(0.5);
        this.normal = new NormalDistribution();
        this.chi = new ChiSquareDistribution();
        this.chi.setDegree(1);
    }

    @Override
    protected void loadFiles() {
    }

    public double computeBinomialAdjustment(double S, double x) {
        this.binom.setN((int)S);
        return this.binom.computeCumulativeProbability((int)x);
    }

    public double computeNormalAdjustment(double Z) {
        return this.normal.getTipifiedProbability(Z, false);
    }

    public double computeChiAdjustment(double T) {
        return this.chi.computeCumulativeProbability(T);
    }

    private static class SingletonHolder {
        public static final McNemarDistribution distribution = new McNemarDistribution();

        private SingletonHolder() {
        }
    }
}

