/*
 * Decompiled with CFR 0.152.
 */
package javanpst.distributions.common.discrete;

import javanpst.distributions.common.Distribution;
import javanpst.utils.Operations;

public final class PoissonDistribution
implements Distribution {
    private double mean;

    public PoissonDistribution() {
        this.mean = 1.0;
    }

    public PoissonDistribution(double mean) {
        this.mean = mean;
    }

    public PoissonDistribution(PoissonDistribution old) {
        this(old.getMean());
    }

    public void setMean(double value) {
        if (value > 0.0) {
            this.mean = value;
        }
    }

    public double getMean() {
        return this.mean;
    }

    @Override
    public double computeProbability(double value) {
        double prob = 0.0;
        int x = (int)Math.floor(value);
        prob = x < 0 ? 0.0 : Math.exp(-this.mean) * Math.pow(this.mean, x) / Operations.factorial(x);
        return prob;
    }

    @Override
    public double computeCumulativeProbability(double value) {
        double prob = 0.0;
        int x = (int)Math.floor(value);
        for (int i = 0; i <= x; ++i) {
            prob += this.computeProbability(x);
        }
        return prob;
    }

    public String toString() {
        String text = "";
        text = text + "Poisson distribution. Parameters Mean:" + this.mean;
        return text;
    }
}

