/*
 * Decompiled with CFR 0.152.
 */
package javanpst.distributions.common.discrete;

import javanpst.distributions.common.Distribution;
import javanpst.utils.Operations;

public final class BinomialDistribution
implements Distribution {
    private int n;
    private double p;

    public BinomialDistribution() {
        this.n = 1;
        this.p = 0.0;
    }

    public BinomialDistribution(int n, double p) {
        this.n = n;
        this.p = p;
    }

    public BinomialDistribution(BinomialDistribution old) {
        this(old.getN(), old.getP());
    }

    public void setP(double value) {
        if (value >= 0.0 && value <= 1.0) {
            this.p = value;
        }
    }

    public double getP() {
        return this.p;
    }

    public void setN(int value) {
        if (value > 0) {
            this.n = value;
        }
    }

    public int getN() {
        return this.n;
    }

    @Override
    public double computeProbability(double value) {
        int x = (int)Math.floor(value);
        double prob = x < 0 ? 0.0 : (x > this.n ? 0.0 : Operations.combinatorial(this.n, x) * Math.pow(this.p, x) * Math.pow(1.0 - this.p, this.n - x));
        return prob;
    }

    @Override
    public double computeCumulativeProbability(double value) {
        double prob = 0.0;
        int x = (int)Math.floor(value);
        if (x >= 0) {
            for (int i = 0; i <= x && prob < 1.0; prob += this.computeProbability(i), ++i) {
            }
        }
        return prob;
    }

    public int getLesserCumulativeProbability(double limit) {
        double prob = 0.0;
        if (this.computeProbability(0.0) > limit) {
            return -1;
        }
        for (int i = 0; i < this.n; ++i) {
            if (!((prob += this.computeProbability(i)) > limit)) continue;
            return i - 1;
        }
        return this.n;
    }

    public int getUpperCumulativeProbability(double limit) {
        double prob = 1.0;
        for (int i = this.n; i > -1; --i) {
            if (!((prob -= this.computeProbability(i)) < limit)) continue;
            return i;
        }
        return this.n;
    }

    public String toString() {
        String text = "";
        text = text + "Binomial distribution. Parameters N:" + this.n + " P:" + this.p;
        return text;
    }
}

