/*
 * Decompiled with CFR 0.152.
 */
package javanpst.distributions.common.continuous;

import javanpst.distributions.common.Distribution;

public class WeibullDistribution
implements Distribution {
    private double lambda;
    private double k;

    public WeibullDistribution() {
        this.lambda = 1.0;
        this.k = 1.0;
    }

    public WeibullDistribution(double lambda, double k) {
        if (k > 0.0 && lambda > 0.0) {
            this.lambda = lambda;
            this.k = k;
        }
    }

    public WeibullDistribution(WeibullDistribution old) {
        this(old.getLambda(), old.getK());
    }

    public void setLambda(double value) {
        if (value > 0.0) {
            this.lambda = value;
        }
    }

    public void setK(double value) {
        if (value > 0.0) {
            this.k = value;
        }
    }

    public double getLambda() {
        return this.lambda;
    }

    public double getK() {
        return this.k;
    }

    @Override
    public double computeProbability(double x) {
        double value = x >= 0.0 ? this.k / this.lambda * Math.pow(x / this.lambda, this.k - 1.0) * Math.pow(Math.E, -1.0 * Math.pow(x / this.lambda, this.k)) : 0.0;
        return value;
    }

    @Override
    public double computeCumulativeProbability(double x) {
        double value = x >= 0.0 ? 1.0 - Math.pow(Math.E, -1.0 * Math.pow(x / this.lambda, this.k)) : 0.0;
        return value;
    }

    public String toString() {
        String text = "";
        text = text + "Weibull distribution. Lambda: " + this.lambda + " K: " + this.k;
        return text;
    }
}

