/*
 * Decompiled with CFR 0.152.
 */
package javanpst.distributions.common.continuous;

import javanpst.distributions.common.Distribution;

public class LogisticDistribution
implements Distribution {
    private double mean;
    private double s;

    public LogisticDistribution() {
        this.mean = 0.0;
        this.s = 1.0;
    }

    public LogisticDistribution(double mean, double s) {
        if (s > 0.0) {
            this.mean = mean;
            this.s = s;
        }
    }

    public LogisticDistribution(LogisticDistribution old) {
        this(old.getMean(), old.getS());
    }

    public void setMean(double value) {
        this.mean = value;
    }

    public void setS(double value) {
        if (value > 0.0) {
            this.s = value;
        }
    }

    public double getMean() {
        return this.mean;
    }

    public double getS() {
        return this.s;
    }

    @Override
    public double computeProbability(double x) {
        double value = Math.pow(Math.E, -(x - this.mean) / this.s);
        double aux = 1.0 + Math.pow(Math.E, -(x - this.mean) / this.s);
        return value /= this.s * aux * aux;
    }

    @Override
    public double computeCumulativeProbability(double x) {
        double value = 1.0 / (1.0 + Math.pow(Math.E, -(x - this.mean) / this.s));
        return value;
    }

    public String toString() {
        String text = "";
        text = text + "Logistic distribution. Mean: " + this.mean + " S: " + this.s;
        return text;
    }
}

