/*
 * Decompiled with CFR 0.152.
 */
package javanpst.distributions.common.continuous;

import javanpst.distributions.common.Distribution;
import javanpst.utils.ContinuedFraction;

public final class GammaDistribution
implements Distribution {
    private double alpha;
    private double beta;

    public GammaDistribution() {
        this.alpha = 1.0;
        this.beta = 1.0;
    }

    public GammaDistribution(double alpha, double beta) {
        this.alpha = alpha;
        this.beta = beta;
    }

    public GammaDistribution(GammaDistribution old) {
        this(old.getAlpha(), old.getBeta());
    }

    public void setAlpha(double value) {
        if (value > 0.0) {
            this.alpha = value;
        }
    }

    public void setK(double value) {
        this.setAlpha(value);
    }

    public void setBeta(double value) {
        if (value > 0.0) {
            this.beta = value;
        }
    }

    public void setLambda(double value) {
        this.setBeta(1.0 / value);
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getK() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    public double getLambda() {
        return 1.0 / this.beta;
    }

    @Override
    public double computeProbability(double value) {
        double prob = Math.pow(value, this.alpha - 1.0) * Math.pow(Math.E, -value / this.beta);
        return prob /= Math.pow(this.beta, this.alpha) * Math.exp(this.logGamma(value));
    }

    private double logGamma(double value) {
        double prob;
        double[] coefficients = new double[]{0.9999999999999971, 57.15623566586292, -59.59796035547549, 14.136097974741746, -0.4919138160976202, 3.399464998481189E-5, 4.652362892704858E-5, -9.837447530487956E-5, 1.580887032249125E-4, -2.1026444172410488E-4, 2.1743961811521265E-4, -1.643181065367639E-4, 8.441822398385275E-5, -2.6190838401581408E-5, 3.6899182659531625E-6};
        if (Double.isNaN(value) || value <= 0.0) {
            prob = Double.NaN;
        } else {
            double sum = 0.0;
            for (int i = 1; i < coefficients.length; ++i) {
                sum += coefficients[i] / (value + (double)i);
            }
            double tmp = value + 4.7421875 + 0.5;
            prob = (value + 0.5) * Math.log(tmp) - tmp + 0.5 * Math.log(Math.PI * 2) + Math.log(sum += coefficients[0]) - Math.log(value);
        }
        return prob;
    }

    @Override
    public double computeCumulativeProbability(double value) {
        double prob = value <= 0.0 ? 0.0 : (Double.isInfinite(value) ? 1.0 : this.regularizedGammaP(this.alpha, value / this.beta));
        return prob;
    }

    public double regularizedGammaP(double a, double x) {
        double prob;
        double EPSILON = 1.0E-8;
        int ITERATIONS = 1000;
        if (x == 0.0) {
            prob = 0.0;
        } else if (x >= a + 1.0) {
            prob = 1.0 - this.regularizedGammaQ(a, x);
        } else {
            double an;
            double n = 0.0;
            double sum = an = 1.0 / a;
            while (Math.abs(an) > EPSILON && n < (double)ITERATIONS) {
                sum += (an *= x / (a + (n += 1.0)));
            }
            prob = Math.exp(-x + a * Math.log(x) - this.logGamma(a)) * sum;
        }
        return prob;
    }

    public double regularizedGammaQ(double a, double x) {
        double prob;
        if (x == 0.0) {
            prob = 1.0;
        } else if (x < a + 1.0) {
            prob = 1.0 - this.regularizedGammaP(a, x);
        } else {
            ContinuedFraction cf = new ContinuedFraction(a);
            prob = 1.0 / cf.evaluate(x);
            prob = Math.exp(-x + a * Math.log(x) - this.logGamma(a)) * prob;
        }
        return prob;
    }

    public String toString() {
        String text = "";
        text = text + "Gamma distribution. Parameters Alpha: " + this.alpha + " Beta: " + this.beta;
        return text;
    }
}

