/*
 * Decompiled with CFR 0.152.
 */
package javanpst.distributions.common.continuous;

import javanpst.distributions.common.Distribution;
import javanpst.distributions.common.continuous.GammaDistribution;

public final class ChiSquareDistribution
implements Distribution {
    private GammaDistribution gamma = new GammaDistribution();
    private int freedom;

    public ChiSquareDistribution() {
        this.gamma.setAlpha((double)this.freedom / 2.0);
        this.gamma.setBeta(2.0);
        this.freedom = 1;
    }

    public ChiSquareDistribution(int degree) {
        this.gamma.setAlpha((double)degree / 2.0);
        this.gamma.setBeta(2.0);
        this.freedom = degree;
    }

    public ChiSquareDistribution(ChiSquareDistribution old) {
        this(old.getDegree());
    }

    public int getDegree() {
        return this.freedom;
    }

    public void setDegree(int value) {
        if (value > 0) {
            this.freedom = value;
            this.gamma.setAlpha((double)this.freedom / 2.0);
            this.gamma.setBeta(2.0);
        }
    }

    @Override
    public double computeProbability(double value) {
        return this.gamma.computeProbability(value);
    }

    @Override
    public double computeCumulativeProbability(double value) {
        return 1.0 - this.computeRightTailProbability(value);
    }

    public double computeRightTailProbability(double value) {
        double EPSILON = 1.0E-10;
        if (this.freedom == 1 & value > 1000.0) {
            return 0.0;
        }
        if (value > 1000.0 || this.freedom > 1000) {
            double q = this.computeRightTailProbability((value - (double)this.freedom) * (value - (double)this.freedom) / (double)(2 * this.freedom)) / 2.0;
            if (value > (double)this.freedom) {
                return q;
            }
            return 1.0 - q;
        }
        double p = Math.exp(-0.5 * value);
        if (this.freedom % 2 == 1) {
            p *= Math.sqrt(2.0 * value / Math.PI);
        }
        for (double k = (double)this.freedom; k >= 2.0; k -= 2.0) {
            p = p * value / k;
        }
        double t = p;
        double a = this.freedom;
        while (t > EPSILON * p) {
            t = t * value / (a += 2.0);
            p += t;
        }
        return p;
    }

    public String toString() {
        String text = "";
        text = text + "Chi-square distribution. Degrees of freedom: " + this.freedom;
        return text;
    }
}

