/*
 * Decompiled with CFR 0.152.
 */
package javanpst.data.structures.dataTable;

import java.util.Arrays;
import javanpst.data.readers.tabularDataReaders.TabularDataCSVReader;
import javanpst.data.readers.tabularDataReaders.TabularDataTXTReader;
import javanpst.data.readers.tabularDataReaders.TabularDataXMLReader;
import javanpst.data.writers.tabularDataWriters.TabularDataCSVWriter;
import javanpst.data.writers.tabularDataWriters.TabularDataTXTWriter;
import javanpst.data.writers.tabularDataWriters.TabularDataXMLWriter;

public class DataTable {
    private double[][] body;
    private boolean[][] nulls;

    public DataTable() {
        this.body = new double[0][0];
        this.nulls = new boolean[0][0];
    }

    public DataTable(double[][] data) {
        this.body = new double[data.length][data[0].length];
        this.nulls = new boolean[data.length][data[0].length];
        for (int i = 0; i < data.length; ++i) {
            System.arraycopy(data[i], 0, this.body[i], 0, data[0].length);
            Arrays.fill(this.nulls[i], false);
        }
    }

    public DataTable(double[][] data, boolean[][] nullV) {
        if (data.length == nullV.length && data[0].length == nullV[0].length) {
            this.body = new double[data.length][data[0].length];
            this.nulls = new boolean[data.length][data[0].length];
            for (int i = 0; i < data.length; ++i) {
                System.arraycopy(data[i], 0, this.body[i], 0, data[0].length);
                System.arraycopy(nullV[i], 0, this.nulls[i], 0, data[0].length);
            }
        } else {
            this.body = new double[0][0];
            this.nulls = new boolean[0][0];
        }
    }

    public static DataTable newInstance(DataTable aTable) {
        DataTable copy = new DataTable(aTable.body, aTable.nulls);
        return copy;
    }

    public double[][] getBody() {
        return this.body;
    }

    public boolean[][] getNulls() {
        return this.nulls;
    }

    public boolean isNull(int row, int col) {
        return this.nulls[row][col];
    }

    public int getRows() {
        return this.body.length;
    }

    public int getColumns() {
        return this.body[0].length;
    }

    public void clear() {
        for (int i = 0; i < this.body.length; ++i) {
            Arrays.fill(this.nulls[i], true);
        }
    }

    public void setDimensions(int row, int col) {
        this.body = new double[row][col];
        this.nulls = new boolean[row][col];
        this.clear();
    }

    public void setRows(int row) {
        this.body = new double[row][this.body[0].length];
        this.nulls = new boolean[row][this.body[0].length];
        this.clear();
    }

    public void setColumns(int col) {
        this.body = new double[this.body.length][col];
        this.nulls = new boolean[this.body.length][col];
        this.clear();
    }

    public void setValue(int row, int col, double value) {
        this.body[row][col] = value;
        this.nulls[row][col] = false;
    }

    public void setNull(int row, int col) {
        this.nulls[row][col] = true;
    }

    public void setRow(int row, double[] array) {
        if (array.length <= this.body[row].length) {
            System.arraycopy(array, 0, this.body[row], 0, array.length);
            Arrays.fill(this.nulls[row], false);
        }
    }

    public void setColumn(int col, double[] array) {
        if (array.length <= this.body.length) {
            for (int i = 0; i < array.length; ++i) {
                this.body[i][col] = array[i];
                this.nulls[i][col] = false;
            }
        }
    }

    public int getRowNulls(int row) {
        int counter = 0;
        for (int i = 0; i < this.body[0].length; ++i) {
            if (!this.nulls[row][i]) continue;
            ++counter;
        }
        return counter;
    }

    public int getColumnNulls(int col) {
        int counter = 0;
        for (int i = 0; i < this.body.length; ++i) {
            if (!this.nulls[i][col]) continue;
            ++counter;
        }
        return counter;
    }

    public double get(int row, int col) {
        if (this.nulls[row][col]) {
            return Double.MIN_VALUE;
        }
        return this.body[row][col];
    }

    public double[] getRow(int row) {
        double[] copy = new double[this.body[row].length];
        System.arraycopy(this.body[row], 0, copy, 0, this.body[row].length);
        return copy;
    }

    public double[] getColumn(int col) {
        double[] copy = new double[this.body.length];
        for (int i = 0; i < copy.length; ++i) {
            copy[i] = this.body[i][col];
        }
        return copy;
    }

    public String toString() {
        String text = "";
        text = text + "*** Rows: " + this.body.length + " Columns: " + this.body[0].length + " **********\n";
        for (int i = 0; i < this.body.length; ++i) {
            String text2 = "";
            for (int j = 0; j < this.body[0].length; ++j) {
                text2 = text2 + this.body[i][j] + "\t";
            }
            text = text + text2 + "\n";
        }
        return text;
    }

    public void readXML(String file) {
        TabularDataXMLReader.readXMLTabularData(file);
        this.body = TabularDataXMLReader.getTable().getBody();
        this.nulls = TabularDataXMLReader.getTable().getNulls();
    }

    public void writeXML(String file) {
        TabularDataXMLWriter.writeTabularData(this, file);
    }

    public void readCSV(String file) {
        TabularDataCSVReader.readCSVTabularData(file);
        this.body = TabularDataCSVReader.getTable().getBody();
        this.nulls = TabularDataCSVReader.getTable().getNulls();
    }

    public void writeCSV(String file, boolean useComma) {
        TabularDataCSVWriter.writeTabularData(this, file, useComma);
    }

    public void readTXT(String file) {
        TabularDataTXTReader.readTXTTabularData(file);
        this.body = TabularDataTXTReader.getTable().getBody();
        this.nulls = TabularDataTXTReader.getTable().getNulls();
    }

    public void writeTXT(String file) {
        TabularDataTXTWriter.writeTabularData(this, file);
    }
}

