/*
 * Decompiled with CFR 0.152.
 */
package javanpst.data.readers.tabularDataReaders;

import java.util.StringTokenizer;
import javanpst.data.structures.dataTable.DataTable;
import javanpst.utils.Files;

public class TabularDataCSVReader {
    private static DataTable table;

    private static void generateTable(int rows, int cols) {
        table = new DataTable();
        table.setDimensions(rows, cols);
    }

    public static DataTable getTable() {
        DataTable tab = DataTable.newInstance(table);
        return tab;
    }

    private static boolean addValue(String value, int row, int col) {
        double val;
        if (value == "NULL") {
            table.setNull(row, col);
        }
        try {
            val = Double.parseDouble(value);
        }
        catch (Exception e) {
            System.out.println("Parsing error on row " + row + " column " + col);
            return false;
        }
        table.setValue(row, col, val);
        return true;
    }

    public static void readCSVTabularData(String file) {
        String content = Files.readFile(file);
        String separator = Files.findSeparator(content);
        TabularDataCSVReader.extractDimensions(content, separator);
        StringTokenizer tokens = new StringTokenizer(content, "\n");
        int indexRow = 0;
        int indexCol = 0;
        boolean state = true;
        while (tokens.hasMoreElements()) {
            String content2 = tokens.nextToken();
            StringTokenizer tokens2 = new StringTokenizer(content2, separator);
            if (tokens2.countTokens() != table.getColumns()) {
                table.clear();
                System.out.println("\nError reading " + table.getRows() + " x " + table.getColumns() + " table. " + "The number of colums is wrong.\n");
                return;
            }
            while (tokens2.hasMoreElements()) {
                String value = tokens2.nextToken();
                state = state && TabularDataCSVReader.addValue(value, indexRow, indexCol);
                ++indexCol;
            }
            if (!state) {
                table.clear();
                return;
            }
            ++indexRow;
            indexCol = 0;
        }
    }

    private static void extractDimensions(String text, String separator) {
        StringTokenizer tokens = new StringTokenizer(text, "\n");
        int nRows = tokens.countTokens();
        String line = tokens.nextToken();
        StringTokenizer tokens2 = new StringTokenizer(line, separator);
        int nColumns = tokens2.countTokens();
        TabularDataCSVReader.generateTable(nRows, nColumns);
    }
}

