/*
 * Decompiled with CFR 0.152.
 */
package javanpst.data.distributions.incompleteTable;

import java.util.Arrays;

public class Incomplete3KeyTable {
    private int[] dimensions = new int[3];
    private double[][][] body;

    public Incomplete3KeyTable(int dim1, int dim2, int dim3) {
        this.dimensions[0] = dim1;
        this.dimensions[1] = dim2;
        this.dimensions[2] = dim3;
        this.body = new double[dim1][dim2][dim3];
        this.clear();
    }

    public void clear() {
        for (int i = 0; i < this.dimensions[0]; ++i) {
            for (int j = 0; j < this.dimensions[1]; ++j) {
                Arrays.fill(this.body[i][j], -1.0);
            }
        }
    }

    public void erase(int dim1, int dim2, int dim3) {
        if (dim1 >= 0 && dim1 < this.dimensions[0] && dim2 >= 0 && dim2 < this.dimensions[1] && dim3 >= 0 && dim3 < this.dimensions[2]) {
            this.body[dim1][dim2][dim3] = -1.0;
        }
    }

    public void add(int dim1, int dim2, int dim3, double value) {
        if (dim1 >= 0 && dim1 < this.dimensions[0] && dim2 >= 0 && dim2 < this.dimensions[1] && dim3 >= 0 && dim3 < this.dimensions[2]) {
            this.body[dim1][dim2][dim3] = value;
        }
    }

    public double get(int dim1, int dim2, int dim3) {
        double value = dim1 >= 0 && dim1 < this.dimensions[0] && dim2 >= 0 && dim2 < this.dimensions[1] && dim3 >= 0 && dim3 < this.dimensions[2] ? this.body[dim1][dim2][dim3] : -1.0;
        return value;
    }
}

