/*
 * Decompiled with CFR 0.152.
 */
package javanpst.data.distributions.aproximateTable;

import java.util.Arrays;

public class Aproximate1KeyTable {
    private double[][] keys;
    private double[][] values;
    private static double EPSILON = 0.002;

    public Aproximate1KeyTable(int integerLenght, int realLenght) {
        this.keys = new double[integerLenght][realLenght];
        this.values = new double[integerLenght][realLenght];
        this.clear();
    }

    public void clear() {
        for (int i = 0; i < this.keys.length; ++i) {
            Arrays.fill(this.keys[i], -1.0);
            Arrays.fill(this.values[i], -1.0);
        }
    }

    public void erase(int index) {
        Arrays.fill(this.keys[index], -1.0);
        Arrays.fill(this.values[index], -1.0);
    }

    public void addRow(int index, double[] keys, double[] values) {
        System.arraycopy(keys, 0, this.keys[index], 0, values.length);
        System.arraycopy(values, 0, this.values[index], 0, values.length);
    }

    public double get(int index, double aproximate) {
        double value = -1.0;
        boolean found = false;
        int pointer = 0;
        while (!found && this.keys[index][pointer] != -1.0 && pointer < this.keys[index].length) {
            if (Math.abs(this.keys[index][pointer] - aproximate) <= EPSILON) {
                found = true;
                continue;
            }
            ++pointer;
        }
        if (found) {
            value = this.values[index][pointer];
        }
        return value;
    }
}

