/*
 * Decompiled with CFR 0.152.
 */
package units;

import units.BuiltInFunction;
import units.DefinedFunction;
import units.EvalError;
import units.Function;
import units.Phrase;
import units.SemanticsBase;
import units.Unit;
import units.Value;

class Semantics
extends SemanticsBase {
    String parm = null;
    Value parmValue;
    Value result;

    Semantics() {
    }

    SV lhSem() {
        return this.sv(this.lhs());
    }

    SV rhSem(int i) {
        return this.sv(this.rhs(i));
    }

    SV sv(Phrase p) {
        SV sv = (SV)p.get();
        if (sv != null) {
            return sv;
        }
        sv = new SV();
        p.put(sv);
        return sv;
    }

    void unitexpr() {
        this.result = this.rhsSize() == 3 ? this.rhSem((int)1).value : new Value();
    }

    void error() {
        throw new EvalError(this.lhs().errMsg());
    }

    void expr() {
        Value v = this.rhSem((int)0).value;
        for (int i = 2; i < this.rhsSize(); i += 2) {
            Value v1 = this.rhSem((int)i).value;
            if (this.rhs(i - 1).isA("MINUS")) {
                v1.factor *= -1.0;
            }
            v.add(v1);
        }
        this.lhSem().value = v;
    }

    void inverse() {
        Value v = this.rhSem((int)1).value;
        v.invert();
        this.lhSem().value = v;
    }

    void term() {
        Value v = this.rhSem((int)0).value;
        for (int i = 2; i < this.rhsSize(); i += 2) {
            if (this.rhs(i - 1).isA("STAR")) {
                v.mult(this.rhSem((int)i).value);
                continue;
            }
            v.div(this.rhSem((int)i).value);
        }
        this.lhSem().value = v;
    }

    void product() {
        Value v = this.rhSem((int)0).value;
        for (int i = 1; i < this.rhsSize(); ++i) {
            v.mult(this.rhSem((int)i).value);
        }
        this.lhSem().value = v;
    }

    void factor() {
        for (int i = this.rhsSize() - 3; i >= 0; i -= 2) {
            this.rhSem((int)i).value.power(this.rhSem((int)(i + 2)).value);
        }
        this.lhSem().value = this.rhSem((int)0).value;
    }

    void unary() {
        Value v = this.rhSem((int)(this.rhsSize() - 1)).value;
        if (this.rhs(0).isA("MINUS")) {
            v.factor *= -1.0;
        }
        this.lhSem().value = v;
    }

    void makeNumUnit() {
        Value v = new Value();
        v.factor = this.rhSem((int)0).number;
        this.lhSem().value = v;
    }

    void pass2() {
        this.lhSem().value = this.rhSem((int)1).value;
    }

    void pass() {
        this.lhSem().value = this.rhSem((int)0).value;
    }

    void evalBfunc() {
        this.lhSem().value = this.rhSem((int)2).value;
        this.rhSem((int)0).func.applyTo(this.lhSem().value);
    }

    void evalUfunc() {
        this.lhSem().value = this.rhSem((int)3).value;
        if (this.rhs(0).isEmpty()) {
            this.rhSem((int)1).func.applyTo(this.lhSem().value);
        } else {
            this.rhSem((int)1).func.applyInverseTo(this.lhSem().value);
        }
    }

    void numexpr() {
        Double d = this.rhSem((int)0).number;
        for (int i = 2; i < this.rhsSize(); i += 2) {
            double d1 = this.rhSem((int)i).number;
            if (d1 == 0.0) {
                throw new EvalError("Division by 0");
            }
            d = d / d1;
        }
        this.lhSem().number = d;
    }

    void number() {
        this.lhSem().number = new Double(this.rhsText(0, this.rhsSize() - 1));
    }

    boolean unitname() {
        String word = this.rhs(0).text();
        if (word.equals("per")) {
            return false;
        }
        if (BuiltInFunction.table.containsKey(word)) {
            return false;
        }
        if (word.equals(this.parm)) {
            this.lhSem().value = new Value(this.parmValue);
            return true;
        }
        if (DefinedFunction.table.containsKey(word)) {
            return false;
        }
        int exp = 1;
        if (!Unit.hasSubscript(word) && (exp = 2 + "23456789".indexOf(word.charAt(word.length() - 1))) > 1) {
            word = word.substring(0, word.length() - 1);
        }
        Value v = Value.fromName(word);
        if (exp > 1) {
            v.power(exp);
        }
        this.lhSem().value = v;
        return true;
    }

    boolean bfunc() {
        String word = this.rhs(0).text();
        if (word.equals("per")) {
            return false;
        }
        Function func = BuiltInFunction.table.get(word);
        if (func == null) {
            return false;
        }
        this.lhSem().func = func;
        return true;
    }

    boolean ufunc() {
        String word = this.rhs(0).text();
        if (word.equals("per")) {
            return false;
        }
        if (word.equals(this.parm)) {
            return false;
        }
        Function func = DefinedFunction.table.get(word);
        if (func == null) {
            return false;
        }
        this.lhSem().func = func;
        return true;
    }

    void space() {
        this.lhs().errClear();
    }

    static class SV {
        double number;
        Value value;
        Function func;

        SV() {
        }
    }
}

