/*
 * Decompiled with CFR 0.152.
 */
package units;

import units.ParserBase;
import units.Source;

public class ParserMemo
extends ParserBase {
    int cacheSize = 1;
    ParserBase.Phrase reuse;
    protected Cache[] caches;

    protected ParserMemo() {
    }

    @Override
    public void init(Source src) {
        super.init(src);
        for (Cache c : this.caches) {
            c.reset();
        }
    }

    public void setMemo(int m) {
        if (m < 1 | m > 9) {
            throw new Error("m=" + m + " outside range 1-9");
        }
        this.cacheSize = m;
    }

    protected boolean saved(Cache c) {
        this.reuse = c.find();
        if (this.reuse != null) {
            return true;
        }
        this.begin(c.name, c.diag);
        c.save(this.current);
        return false;
    }

    protected boolean savedInner(Cache c) {
        this.reuse = c.find();
        if (this.reuse != null) {
            return true;
        }
        this.begin("", c.diag);
        c.save(this.current);
        return false;
    }

    protected boolean reuse() {
        if (this.reuse.success) {
            this.current.end = this.pos = this.reuse.end;
            this.current.rhs.add(this.reuse);
            this.current.errMerge(this.reuse);
            return true;
        }
        this.current.errMerge(this.reuse);
        return false;
    }

    protected boolean reuseInner() {
        if (this.reuse.success) {
            this.current.end = this.pos = this.reuse.end;
            this.current.rhs.addAll(this.reuse.rhs);
            this.current.errMerge(this.reuse);
            return true;
        }
        this.current.errMerge(this.reuse);
        return false;
    }

    protected boolean reusePred() {
        if (this.reuse.success) {
            return true;
        }
        this.current.errMerge(this.reuse);
        return false;
    }

    protected class Cache {
        public final String name;
        public final String diag;
        ParserBase.Phrase[] cache;
        int last;

        public Cache(String name) {
            this.name = name;
            this.diag = name;
        }

        public Cache(String name, String diag) {
            this.name = name;
            this.diag = diag;
        }

        void reset() {
            this.cache = new ParserBase.Phrase[ParserMemo.this.cacheSize];
            this.last = 0;
        }

        void save(ParserBase.Phrase p) {
            this.last = (this.last + 1) % ParserMemo.this.cacheSize;
            this.cache[this.last] = p;
        }

        ParserBase.Phrase find() {
            for (ParserBase.Phrase p : this.cache) {
                if (p == null || p.start != ParserMemo.this.pos) continue;
                return p;
            }
            return null;
        }
    }
}

