/*
 * Decompiled with CFR 0.152.
 */
package units;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import units.Browser;
import units.Env;
import units.Tables;
import units.Value;

public class GUI
extends Container
implements ActionListener {
    public static final String HELP = " Units is a program for computations on values expressed in terms\n of different measurement units. It is an advanced calculator\n that takes care of the units. An example shows how to use it:\n Suppose you want to compute the mass, in pounds, of water\n that fills to the depth of 7 inches a rectangular area measuring\n 5 yards by 4 feet 3 inches. You recall that 1 liter of water\n has the mass of 1 kilogram. To compute the weight, you multiply\n the water's volume by its specific mass, like this:\n\n   5 yds * (4 feet + 3 in) * 7 in * 1 kg/liter\n\n Just type this computation in 'You have' field, enter 'pounds'\n at 'You want', and press 'Compute'. The result is shown like this:\n\n   5 yds * (4 feet + 3 in) * 7 in * 1 kg/liter = 2321.5398 pounds\n\n You do not bother about conversions between yards, inches, feet,\n liters, kilograms, and pounds. The caculator does it all for you.\n\n If you leave 'You want:' field empty, you obtain the result\n reduced to standard primitive units; in this case, 1053.0327 kg.\n Press 'Conformable units' for a list of other units in which\n you can express your result.\n\n Enter a unit name in 'You have:' field and press 'Definition'\n to see the definition of that unit. Press 'Source' to explore\n units database around the definition of that unit. Press 'Search'\n to find units whose names contain the 'You have' string.\n\n You can also use Units for simple conversions:\n\n Feet and inches to meters:\n   You have: 6 ft + 7 in\n   You want: m\n     6 ft + 7 in = 2.0066 m\n\n Meters to feet and inches:\n   You have: 2 m\n   You want: ft;in;1|8in\n     2 m = 6 ft + 6 in + 5.9212598 * 1|8in\n\n Temperature from Fahrenheit to Celsius:\n   You have: tempF(75)\n   You want: tempC\n     tempF(75) = tempC(23.888889)\n\n Reciprocal conversion (volume / distance to distance / volume.):\n   You have: 8 liters / 100 km\n   You want: miles / gallon\n     reciprocal conversion\n     1 / (8 liters / 100 km) = 0.034011497 miles / gallon\n\n Compound result units:\n   You have: 5 mA\n   You want: e/sec\n           5mA = 3.1207548e16 e/sec\n (units data base defines 'e' as the charge of an electron.)\n\n See http://units-in-java.sourceforge.net for user's manual.\n";
    JTextField haveField = new JTextField();
    JTextField wantField = new JTextField();
    JTextArea outArea = new JTextArea(10, 10);
    JScrollPane scroll = new JScrollPane(this.outArea, 20, 30);
    JButton aboutKey = new JButton("About Units");
    JButton clearKey = new JButton("Clear");
    JButton conformKey = new JButton("Conformable units");
    JButton convertKey = new JButton("Compute");
    JButton helpKey = new JButton("Help");
    JButton defKey = new JButton("Definition");
    JButton searchKey = new JButton("Search");
    JButton sourceKey = new JButton("Source");
    static final long serialVersionUID = 4711L;

    GUI(JRootPane rootPane) {
        if (Env.guiFont == null) {
            Env.guiFont = new Font(Env.font, 0, 12);
        }
        this.setLayout(new BorderLayout());
        JPanel dialog = new JPanel(new GridLayout(2, 0));
        this.add((Component)dialog, "North");
        JPanel havePart = new JPanel(new BorderLayout());
        dialog.add(havePart);
        JPanel haveLine = new JPanel(new BorderLayout());
        havePart.add((Component)haveLine, "North");
        haveLine.add((Component)new JLabel("  "), "North");
        haveLine.add((Component)new JLabel(" "), "East");
        haveLine.add((Component)new JLabel("  You have:  "), "West");
        haveLine.add((Component)this.haveField, "Center");
        JPanel haveKeys = new JPanel(new FlowLayout(2));
        havePart.add((Component)haveKeys, "South");
        haveKeys.add(this.searchKey);
        haveKeys.add(this.conformKey);
        haveKeys.add(this.defKey);
        haveKeys.add(this.sourceKey);
        JPanel wantPart = new JPanel(new BorderLayout());
        dialog.add(wantPart);
        JPanel wantLine = new JPanel(new BorderLayout());
        wantPart.add((Component)wantLine, "North");
        wantLine.add((Component)new JLabel(" "), "North");
        wantLine.add((Component)new JLabel(""), "East");
        wantLine.add((Component)new JLabel("  You want:  "), "West");
        wantLine.add((Component)this.wantField, "Center");
        wantLine.add((Component)new JLabel(" "), "East");
        JPanel wantKeys = new JPanel(new FlowLayout(2));
        wantPart.add((Component)wantKeys, "South");
        wantKeys.add(this.convertKey);
        this.add((Component)this.scroll, "Center");
        this.add((Component)new JLabel(" "), "East");
        this.add((Component)new JLabel(" "), "West");
        JPanel control = new JPanel(new FlowLayout(2));
        this.add((Component)control, "South");
        control.add(this.aboutKey);
        control.add(this.clearKey);
        control.add(this.helpKey);
        this.aboutKey.addActionListener(this);
        this.clearKey.addActionListener(this);
        this.conformKey.addActionListener(this);
        this.convertKey.addActionListener(this);
        this.defKey.addActionListener(this);
        this.helpKey.addActionListener(this);
        this.searchKey.addActionListener(this);
        this.sourceKey.addActionListener(this);
        rootPane.setDefaultButton(this.convertKey);
        this.haveField.setFont(Env.guiFont);
        this.wantField.setFont(Env.guiFont);
        this.outArea.setFont(Env.guiFont);
        this.outArea.setEditable(false);
        this.outArea.setMargin(new Insets(0, 8, 0, 8));
        this.outArea.setLineWrap(true);
        this.outArea.setTabSize(3);
        Env.out = new myOut();
    }

    JButton defaultButton() {
        return this.convertKey;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String havestr;
        String arg = e.getActionCommand();
        if (arg.equals("Search")) {
            this.outArea.setText(null);
            havestr = this.haveField.getText().trim();
            if (havestr.length() == 0) {
                Env.out.println("Enter search string in 'You have' and try again.");
                return;
            }
            Tables.showMatching(havestr);
        }
        if (arg.equals("Conformable units")) {
            this.outArea.setText(null);
            havestr = this.haveField.getText().trim();
            if (havestr.length() == 0) {
                Env.out.println("Enter 'You have' expression and try again.");
                return;
            }
            Value have = Value.fromString(havestr);
            if (have == null) {
                Env.out.println("Enter a valid unit expression and try again.");
                return;
            }
            Tables.showConformable(have, havestr);
        } else {
            if (arg.equals("Definition")) {
                this.outArea.setText(null);
                havestr = this.haveField.getText().trim();
                if (havestr.length() == 0) {
                    Env.out.println("Enter 'You have' expression and try again.");
                    return;
                }
                String haveDef = Tables.showdef(havestr, true);
                if (haveDef != null) {
                    Env.out.println(haveDef);
                    return;
                }
                Env.out.println("'" + havestr + "' is not the name of a unit, function, or unit list." + "\nPress 'Compute' to see the reduced form, " + "\nor correct 'You have' expression and try again.");
                return;
            }
            if (arg.equals("Source")) {
                this.outArea.setText(null);
                havestr = this.haveField.getText().trim();
                if (havestr.length() == 0) {
                    Env.out.println("Enter 'You have' expression and try again.");
                    return;
                }
                Tables.showSource(havestr);
            } else {
                if (arg.equals("Compute")) {
                    this.outArea.setText(null);
                    havestr = this.haveField.getText().trim();
                    if (havestr.length() == 0) {
                        Env.out.println("Enter 'You have' expression and try again.");
                        return;
                    }
                    Value have = Value.fromString(havestr);
                    if (have == null) {
                        Env.out.println("Correct 'You have' expression and try again.");
                        return;
                    }
                    String wantstr = this.wantField.getText().trim();
                    if (wantstr.length() == 0) {
                        have.show();
                        return;
                    }
                    Env.convert(havestr, have, wantstr);
                    return;
                }
                if (arg.equals("Clear")) {
                    this.haveField.setText(null);
                    this.wantField.setText(null);
                    this.outArea.setText(null);
                } else if (arg.equals("About Units")) {
                    this.outArea.setText("");
                    Env.showAbout();
                    this.scroll.getViewport().setViewPosition(new Point(0, 0));
                    this.outArea.select(0, 0);
                } else if (arg.equals("Help")) {
                    Browser.show("Units help", HELP, 0, 0, false);
                }
            }
        }
    }

    private class myOut
    extends Env.Writer {
        private myOut() {
        }

        @Override
        void print(String s) {
            GUI.this.outArea.append(s);
        }

        @Override
        void println(String s) {
            GUI.this.outArea.append(s + "\n");
        }
    }
}

