/*
 * Decompiled with CFR 0.152.
 */
package units;

import units.Alias;
import units.ComputedFunction;
import units.Env;
import units.Location;
import units.Prefix;
import units.SemanticsBase;
import units.TabularFunction;
import units.Unit;
import units.UnitsFile;

class FileSemantics
extends SemanticsBase {
    Location loc;
    int depth;
    boolean wronglocale = false;
    boolean inlocale = false;

    FileSemantics() {
    }

    void locale() {
        String argument = this.rhs(1).text().trim();
        if (this.inlocale) {
            Env.out.println(this.loc.where() + ". Nested locales are not allowed.");
            return;
        }
        if (argument.isEmpty()) {
            Env.out.println(this.loc.where() + ". No locale specified.");
            return;
        }
        this.inlocale = true;
        if (!argument.equals(Env.locale)) {
            this.wronglocale = true;
            return;
        }
    }

    void badloc() {
        Env.out.println(this.loc.where() + ". No locale specified.");
    }

    void endlocale() {
        if (!this.inlocale) {
            Env.out.println(this.loc.where() + ". Unmatched !endlocale.");
            return;
        }
        this.inlocale = false;
        this.wronglocale = false;
    }

    void include() {
        if (this.wronglocale) {
            return;
        }
        String argument = this.rhs(1).text().trim();
        if (argument.isEmpty()) {
            Env.out.println(this.loc.where() + ". No file name specified.");
            return;
        }
        if (this.depth >= 5) {
            Env.out.println(this.loc.where() + ". Max include depth of " + 5 + " exceeded.");
            return;
        }
        UnitsFile infile = new UnitsFile(argument);
        boolean ok = infile.readunits(this.depth + 1);
        if (ok) {
            Env.filenames.add(infile.name);
        }
    }

    void badincl() {
        Env.out.println(this.loc.where() + ". No file name specified.");
    }

    void unitlist() {
        if (this.wronglocale) {
            return;
        }
        String name = this.rhs(2).text();
        String argument = this.rhs(4).text().trim();
        if (argument.isEmpty()) {
            Env.out.println(this.loc.where() + ". No unit list specified for '" + name + "'.");
            return;
        }
        Alias.define(name, argument, this.loc);
    }

    void badlist() {
        Env.out.println(this.loc.where() + ". No name specified with '!unitlist'.");
    }

    void badcomm() {
        Env.out.println(this.loc.where() + ". Unrecognized command '!" + this.rhsText(0, 1) + "'.");
    }

    void funcdef1() {
        if (this.wronglocale) {
            return;
        }
        String name = this.rhs(0).text();
        String param = this.rhs(2).text();
        String fwddim = this.rhs(6).text().trim();
        String invdim = this.rhs(8).text().trim();
        String fwddef = this.rhs(10).text().trim();
        String invdef = null;
        if (this.rhsSize() > 12) {
            invdef = this.rhs(12).text().trim();
        }
        if (fwddef.isEmpty()) {
            Env.out.println(this.loc.where() + ". Function '" + name + "' is ignored. Definition missing.");
            return;
        }
        if (fwddim.isEmpty()) {
            fwddim = null;
        }
        if (invdim.isEmpty()) {
            invdim = null;
        }
        ComputedFunction.define(name, param, fwddim, invdim, fwddef, invdef, this.loc);
    }

    void funcdef2() {
        if (this.wronglocale) {
            return;
        }
        String name = this.rhs(0).text();
        String param = this.rhs(2).text();
        String fwddef = this.rhs(4).text().trim();
        String invdef = null;
        if (this.rhsSize() > 6) {
            invdef = this.rhs(6).text().trim();
        }
        if (fwddef.isEmpty()) {
            Env.out.println(this.loc.where() + ". Function '" + name + "' is ignored. Definition missing.");
            return;
        }
        ComputedFunction.define(name, param, null, null, fwddef, invdef, this.loc);
    }

    void baddim() {
        if (this.wronglocale) {
            return;
        }
        String name = this.rhs(0).text();
        Env.out.println(this.loc.where() + ". Function '" + name + "' is ignored. Argument dimensions not found after '['.");
    }

    void badfunc() {
        if (this.wronglocale) {
            return;
        }
        String name = this.rhs(0).text();
        Env.out.println(this.loc.where() + ". Function '" + name + "' is ignored. Parameter not found after '('.");
    }

    void tabdef() {
        if (this.wronglocale) {
            return;
        }
        String name = this.rhs(0).text();
        String resUnit = this.rhs(2).text().trim();
        int npairs = this.rhsSize() - 6;
        if (npairs == 1) {
            Env.out.println(this.loc.where() + ". Function '" + name + "' is ignored. Only one point is defined.");
            return;
        }
        double[] x = new double[npairs];
        double[] y = new double[npairs];
        for (int i = 0; i < npairs; ++i) {
            Pair pair = (Pair)this.rhs(i + 5).get();
            x[i] = pair.x;
            y[i] = pair.y;
        }
        TabularFunction.define(name, resUnit, x, y, this.loc);
    }

    void badtab() {
        if (this.wronglocale) {
            return;
        }
        String name = this.rhs(0).text();
        Env.out.println(this.loc.where() + ". Function '" + name + "' is ignored. Result unit not found after '['.");
    }

    void unitdef() {
        if (this.wronglocale) {
            return;
        }
        String name = this.rhs(0).text();
        String def = this.rhs(2).text().trim();
        if (def.isEmpty()) {
            Env.out.println(this.loc.where() + ". Unit '" + name + "' is ignored. Definition missing.");
            return;
        }
        if (name.endsWith("-")) {
            Prefix.define(name, def, this.loc);
        } else {
            Unit.define(name, def, this.loc);
        }
    }

    void badunit() {
        if (this.wronglocale) {
            return;
        }
        String name = this.rhs(0).text();
        Env.out.println(this.loc.where() + ". Unit '" + name + "' is ignored. Definition missing.");
    }

    void pair() {
        this.lhs().put(new Pair((Double)this.rhs(0).get(), (Double)this.rhs(1).get()));
    }

    void number() {
        this.lhs().put(Double.valueOf(this.lhs().text()));
    }

    class Pair {
        double x;
        double y;

        Pair(Double x, Double y) {
            this.x = x;
            this.y = y;
        }
    }
}

