/*
 * Decompiled with CFR 0.152.
 */
package units;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import units.Env;

class Browser
extends JFrame
implements WindowListener {
    private static Browser theWindow = null;
    private JScrollPane pane;
    private JTextArea area;
    static final long serialVersionUID = 4711L;

    Browser() {
        super("Units");
        if (Env.guiFont == null) {
            Env.guiFont = new Font(Env.font, 0, 12);
        }
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        int width = size.width;
        int height = size.height;
        this.setSize(width * 5 / 9, height * 24 / 25);
        this.setLocation(width / 10, height / 50);
        this.area = new JTextArea(10, 10);
        this.area.setMargin(new Insets(10, 10, 10, 10));
        this.area.setFont(Env.guiFont);
        this.area.setEditable(false);
        this.pane = new JScrollPane(this.area, 22, 30);
        this.getContentPane().add(this.pane);
        this.addWindowListener(this);
        this.setResizable(true);
        this.setVisible(true);
        this.validate();
    }

    static void show(String title, String text, int beginSel, int endSel, boolean scroll) {
        if (theWindow == null) {
            theWindow = new Browser();
        }
        JScrollPane sp = Browser.theWindow.pane;
        JTextArea ta = Browser.theWindow.area;
        theWindow.setTitle(title);
        ta.setText(text);
        int lineHeight = ta.getFontMetrics(ta.getFont()).getHeight();
        int midSel = (beginSel + endSel) / 2;
        int scrollPos = 0;
        JViewport vp = sp.getViewport();
        vp.setScrollMode(1);
        if (scroll) {
            int line = 0;
            try {
                line = ta.getLineOfOffset(midSel);
            }
            catch (Exception e) {
                Env.out.println(e.getMessage());
            }
            int height = (int)vp.getExtentSize().getHeight();
            scrollPos = line * lineHeight - height / 2;
            if (scrollPos < 0) {
                scrollPos = 0;
            }
        }
        theWindow.toFront();
        vp.setViewPosition(new Point(0, scrollPos));
        ta.select(beginSel, endSel);
    }

    static void close() {
        theWindow.dispose();
        theWindow = null;
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        Browser.close();
    }
}

